/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.preview;

import com.github.euler.preview.ScalrConfig;
import com.typesafe.config.Config;
import java.awt.image.BufferedImageOp;
import org.imgscalr.Scalr;

public class PreviewUtils {
    private PreviewUtils() {
    }

    public static ScalrConfig fromConfig(Config config) {
        Scalr.Method method = (Scalr.Method)config.getEnum(Scalr.Method.class, "method");
        Scalr.Mode mode = (Scalr.Mode)config.getEnum(Scalr.Mode.class, "mode");
        int width = config.getInt("width");
        int height = config.getInt("height");
        BufferedImageOp[] ops = PreviewUtils.getOps(config, "ops");
        return new ScalrConfig(method, mode, width, height, ops);
    }

    private static BufferedImageOp[] getOps(Config config, String path) {
        return (BufferedImageOp[])config.getStringList(path).stream().map(o -> {
            try {
                BufferedImageOp op = (BufferedImageOp)Scalr.class.getField((String)o).get(null);
                return op;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }).toArray(BufferedImageOp[]::new);
    }
}

