/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.preview;

import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.core.EulerHooks;
import com.github.euler.preview.AbstractPreviewGeneratorConfigConverter;
import com.github.euler.preview.JODConverterPreviewGenerator;
import com.github.euler.preview.PreviewGenerator;
import com.typesafe.config.Config;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.local.office.LocalOfficeManager;

public class JODConverterPreviewGeneratorConfigConverter
extends AbstractPreviewGeneratorConfigConverter {
    public String configType() {
        return "openoffice";
    }

    public PreviewGenerator convert(Config config, ConfigContext configContext, TypesConfigConverter typeConfigConverter) {
        JODConverterPreviewGenerator.Config jodConfig = new JODConverterPreviewGenerator.Config();
        jodConfig.setInitialPage(0);
        jodConfig.setFinalPage(1);
        OfficeManager officeManager = this.buildOfficeManager();
        EulerHooks hooks = (EulerHooks)configContext.getRequired(EulerHooks.class);
        hooks.registerInitializable(() -> {
            try {
                officeManager.start();
            }
            catch (OfficeException e) {
                throw new RuntimeException(e);
            }
        });
        hooks.registerCloseable(() -> {
            try {
                officeManager.stop();
            }
            catch (OfficeException e) {
                throw new RuntimeException(e);
            }
        });
        return new JODConverterPreviewGenerator(jodConfig, officeManager);
    }

    private OfficeManager buildOfficeManager() {
        try {
            return ((LocalOfficeManager.Builder)LocalOfficeManager.builder().workingDir(Files.createTempDirectory("ooffice", new FileAttribute[0]).toFile())).portNumbers(new int[]{JODConverterPreviewGeneratorConfigConverter.findFreePort()}).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int findFreePort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not find an open port.", e);
            }
        }
        socket.close();
        return n;
    }
}

