/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.preview;

import com.github.euler.common.AbstractStorageStrategyConfigConverter;
import com.github.euler.common.StorageStrategy;
import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.preview.PreviewCacheStorageStrategy;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.net.URL;

public class PreviewCacheStorageStrategyConfigConverter
extends AbstractStorageStrategyConfigConverter {
    public String configType() {
        return "preview-cache";
    }

    public StorageStrategy convert(Config config, ConfigContext configContext, TypesConfigConverter typeConfigConverter) {
        config = config.withFallback((ConfigMergeable)this.getDefaultConfig());
        File root = new File(config.getString("root"));
        String suffix = config.getString("suffix");
        int width = config.getInt("width");
        int height = config.getInt("height");
        return new PreviewCacheStorageStrategy(root, suffix, width, height);
    }

    private Config getDefaultConfig() {
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("previewcache.conf");
        return ConfigFactory.parseURL((URL)resource);
    }
}

