/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.preview;

import com.github.euler.common.StorageStrategy;
import com.github.euler.common.StreamFactory;
import com.github.euler.core.Item;
import com.github.euler.core.ItemProcessor;
import com.github.euler.core.ProcessingContext;
import com.github.euler.preview.EulerPreview;
import com.github.euler.preview.MediaType;
import com.github.euler.preview.OutputStreamPreviewHandler;
import com.github.euler.preview.PreviewContext;
import com.github.euler.preview.PreviewHandler;
import com.github.euler.preview.ResizePreviewHandler;
import com.github.euler.preview.ScalrConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;

public class PreviewItemProcessor
implements ItemProcessor {
    public static final String PREVIEW_METADATA = "preview";
    private final EulerPreview preview;
    private final PreviewContext ctx;
    private final String formatName;
    private final ScalrConfig resizeConfig;
    private final StreamFactory streamFactory;
    private final StorageStrategy storageStrategy;

    public PreviewItemProcessor(EulerPreview preview, PreviewContext ctx, String formatName, ScalrConfig resizeConfig, StreamFactory streamFactory, StorageStrategy storageStrategy) {
        this.preview = preview;
        this.ctx = ctx;
        this.formatName = formatName;
        this.resizeConfig = resizeConfig;
        this.streamFactory = streamFactory;
        this.storageStrategy = storageStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingContext process(Item item) throws IOException {
        MediaType type = this.getMime(item);
        URI outFile = this.storageStrategy.createFile("." + this.formatName.toLowerCase());
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.streamFactory.openInputStream(item.itemURI, item.ctx);
            out = this.streamFactory.openOutputStream(outFile, item.ctx);
            ResizePreviewHandler handler = new ResizePreviewHandler(this.resizeConfig, (PreviewHandler)new OutputStreamPreviewHandler(out, this.formatName), false);
            this.preview.generate(this.ctx, type, in, (PreviewHandler)handler);
            ProcessingContext.Builder builder = ProcessingContext.builder();
            builder.metadata(PREVIEW_METADATA, (Object)outFile.toString());
            ProcessingContext processingContext = builder.build();
            return processingContext;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private MediaType getMime(Item item) {
        String mime = (String)item.ctx.metadata("mime-type", item.ctx.context("mime-type"));
        return MediaType.parse((String)mime);
    }
}

