/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.file;

import com.github.euler.common.AbstractStorageStrategyConfigConverter;
import com.github.euler.common.StorageStrategy;
import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.file.FileStorageStrategy;
import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class FileStorageStrategyConfigConverter
extends AbstractStorageStrategyConfigConverter {
    public static final String TEMPORARY_ROOT_FOLDER = "temporary-folder";

    public StorageStrategy convert(Config config, ConfigContext configContext, TypesConfigConverter typeConfigConverter) {
        File root = this.getRoot(config);
        String suffix = config.getString("suffix");
        return new FileStorageStrategy(root, suffix);
    }

    private File getRoot(Config config) {
        String root = config.getString("root");
        if (root.equals(TEMPORARY_ROOT_FOLDER)) {
            try {
                return Files.createTempDirectory("euler", new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new File(root);
    }

    public String configType() {
        return "file";
    }
}

