/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.file;

import com.github.euler.core.AbstractPausableSource;
import com.github.euler.core.ProcessingContext;
import com.github.euler.core.SourceListener;
import com.github.euler.file.FileTreeIterator;
import com.github.euler.file.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;

public class FileSource
extends AbstractPausableSource {
    private static final int DEFAULT_MAX_ITEMS_PER_YIELD = 100;
    private static final Pattern DEFAULT_REGEX = Pattern.compile(".+");
    private static final boolean DEFAULT_NOTIFY_DIRECTORIES = true;
    private final int maxItemsPerYield;
    private final Pattern regex;
    private final boolean notifyDirectories;
    private int itemsFound;
    private Iterator<File> fileIterator;
    private URI uri;

    public FileSource(int maxItemsPerYield) {
        this(maxItemsPerYield, DEFAULT_REGEX, true);
    }

    public FileSource() {
        this(100, DEFAULT_REGEX, true);
    }

    public FileSource(Pattern regex) {
        this(100, regex, true);
    }

    public FileSource(int maxItemsPerYield, Pattern regex, boolean notifyDirectories) {
        this.maxItemsPerYield = maxItemsPerYield;
        this.regex = regex;
        this.notifyDirectories = notifyDirectories;
    }

    public void prepareScan(URI uri) {
        this.uri = uri;
        Path path = FileUtils.toPath(uri);
        this.fileIterator = path.toFile().isDirectory() ? new FileTreeIterator(path.toFile()) : Arrays.asList(path.toFile()).iterator();
    }

    public boolean doScan(SourceListener listener) throws IOException {
        while (this.fileIterator.hasNext() && this.itemsFound <= this.maxItemsPerYield) {
            File found = this.fileIterator.next();
            if ((!found.isDirectory() || !this.notifyDirectories) && (!found.isFile() || !this.regex.matcher(found.getAbsolutePath()).matches())) continue;
            ++this.itemsFound;
            listener.notifyItemFound(this.uri, found.toURI(), ProcessingContext.EMPTY);
        }
        if (this.fileIterator.hasNext()) {
            this.itemsFound = 0;
        }
        return !this.fileIterator.hasNext();
    }

    public void finishScan() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int maxItemsPerYield = 100;
        private Pattern regex = DEFAULT_REGEX;
        private boolean notifyDirectories = true;

        private Builder() {
        }

        public int getMaxItemsPerYield() {
            return this.maxItemsPerYield;
        }

        public Builder setMaxItemsPerYield(int maxItemsPerYield) {
            this.maxItemsPerYield = maxItemsPerYield;
            return this;
        }

        public Pattern getRegex() {
            return this.regex;
        }

        public Builder setRegex(Pattern regex) {
            this.regex = regex;
            return this;
        }

        public boolean isNotifyDirectories() {
            return this.notifyDirectories;
        }

        public Builder setNotifyDirectories(boolean notifyDirectories) {
            this.notifyDirectories = notifyDirectories;
            return this;
        }

        public FileSource build() {
            return new FileSource(this.maxItemsPerYield, this.regex, this.notifyDirectories);
        }
    }
}

