/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.file;

import akka.actor.typed.Behavior;
import com.github.euler.configuration.AbstractSourceConfigConverter;
import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.core.PausableSource;
import com.github.euler.core.PausableSourceExecution;
import com.github.euler.core.SourceCommand;
import com.github.euler.file.FileSource;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FileSourceConfigConverter
extends AbstractSourceConfigConverter {
    public String configType() {
        return "file";
    }

    public Behavior<SourceCommand> convert(Config config, ConfigContext configContext, TypesConfigConverter typeConfigConverter) {
        config = config.withFallback((ConfigMergeable)this.getDefaultConfig());
        FileSource.Builder builder = FileSource.builder();
        builder.setMaxItemsPerYield(config.getInt("max-items-per-yield"));
        builder.setNotifyDirectories(config.getBoolean("notify-directories"));
        int flags = this.getFlags(config.getStringList("regex-flags"));
        Pattern regex = Pattern.compile(config.getString("regex"), flags);
        builder.setRegex(regex);
        return PausableSourceExecution.create((PausableSource)builder.build());
    }

    protected Integer getFlags(List<String> flags) {
        return flags.stream().map(f -> {
            try {
                return Pattern.class.getField((String)f).getInt(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.reducing(0, (i1, i2) -> i1 | i2));
    }

    protected Config getDefaultConfig() {
        URL resource = FileSourceConfigConverter.class.getClassLoader().getResource("filesource.conf");
        return ConfigFactory.parseURL((URL)resource);
    }
}

