/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.file;

import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.actor.typed.javadsl.ReceiveBuilder;
import akka.japi.function.Function;
import com.github.euler.core.JobTaskFinished;
import com.github.euler.core.JobTaskToProcess;
import com.github.euler.core.ProcessingContext;
import com.github.euler.core.TaskCommand;
import com.github.euler.file.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;

public class BasicFilePropertiesExecution
extends AbstractBehavior<TaskCommand> {
    public static Behavior<TaskCommand> create() {
        return Behaviors.setup((Function & Serializable)context -> new BasicFilePropertiesExecution((ActorContext<TaskCommand>)context));
    }

    public BasicFilePropertiesExecution(ActorContext<TaskCommand> context) {
        super(context);
    }

    public Receive<TaskCommand> createReceive() {
        ReceiveBuilder builder = this.newReceiveBuilder();
        builder.onMessage(JobTaskToProcess.class, this::onJobTaskToProcess);
        return builder.build();
    }

    private Behavior<TaskCommand> onJobTaskToProcess(JobTaskToProcess msg) throws IOException {
        File file = this.getFile(msg);
        ProcessingContext.Builder builder = ProcessingContext.builder();
        builder.putAll(msg.ctx);
        builder.metadata("name", (Object)file.getName());
        builder.metadata("size", (Object)file.length());
        builder.metadata("is-directory", (Object)file.isDirectory());
        builder.metadata("full-path", (Object)file.getAbsolutePath());
        String parentScheme = msg.uri.getScheme();
        if (parentScheme.equals("file")) {
            File parent = Paths.get(msg.uri).toFile();
            String relativePath = FileUtils.getRelativePath(parent, file);
            builder.metadata("path", (Object)relativePath);
            builder.metadata("relative-path", (Object)relativePath);
        } else {
            if (msg.ctx.context().containsKey("path")) {
                builder.metadata("path", msg.ctx.context("path"));
            }
            if (msg.ctx.context().containsKey("relative-path")) {
                builder.metadata("relative-path", msg.ctx.context("relative-path"));
            }
        }
        BasicFileAttributes fileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        builder.metadata("created-datetime", (Object)new Date(fileAttributes.creationTime().toMillis()));
        builder.metadata("last-modified-datetime", (Object)new Date(fileAttributes.lastModifiedTime().toMillis()));
        ProcessingContext ctx = builder.build();
        msg.replyTo.tell((Object)new JobTaskFinished(msg, ctx));
        return this;
    }

    private File getFile(JobTaskToProcess msg) {
        String scheme = msg.itemURI.getScheme();
        File file = null;
        if (scheme.equals("file")) {
            file = Paths.get(msg.itemURI).toFile();
        } else if (msg.ctx.metadata().containsKey("full-path")) {
            file = new File((String)msg.ctx.metadata("full-path"));
        } else if (msg.ctx.context().containsKey("full-path")) {
            file = new File((String)msg.ctx.context("full-path"));
        } else {
            throw new NullPointerException("itemURI must be a file scheme or full-path as context or metadata must be provided.");
        }
        return file;
    }
}

