/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.file;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class FileTreeIterator
implements Iterator<File> {
    private File root;
    private List<Iterator<File>> dirIteratorStack = null;
    private Iterator<File> fileIterator = null;
    private boolean rootReturned = false;
    private final FileFilter fileOnly = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isFile();
        }
    };
    private final FileFilter dirOnly = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }
    };

    public FileTreeIterator(File root) {
        this.root = root;
        this.dirIteratorStack = new ArrayList<Iterator<File>>();
        this.init();
    }

    private void init() {
        this.fileIterator = Arrays.stream(this.root.listFiles(this.fileOnly)).iterator();
        this.pushStack(this.root);
    }

    @Override
    public boolean hasNext() {
        return this.hasRoot() || this.hasNextFile() || this.hasNextDir();
    }

    private boolean hasRoot() {
        return !this.rootReturned;
    }

    private boolean hasNextFile() {
        return this.fileIterator != null && this.fileIterator.hasNext();
    }

    private boolean hasNextDir() {
        while (this.dirIteratorStack.size() > 0) {
            Iterator<File> topIterator = this.getTopIterator();
            if (topIterator.hasNext()) {
                return true;
            }
            this.popStack();
        }
        return false;
    }

    @Override
    public File next() {
        if (this.hasRoot()) {
            return this.root();
        }
        if (this.hasNextFile()) {
            return this.nextFile();
        }
        if (this.hasNextDir()) {
            return this.nextDir();
        }
        throw new NoSuchElementException();
    }

    private File root() {
        this.rootReturned = true;
        return this.root;
    }

    private File nextFile() {
        File file = this.fileIterator.next();
        if (!this.fileIterator.hasNext()) {
            this.fileIterator = null;
        }
        return file;
    }

    private File nextDir() {
        Iterator<File> dirIterator = this.getTopIterator();
        File dir = dirIterator.next();
        this.fileIterator = Arrays.stream(dir.listFiles(this.fileOnly)).iterator();
        this.pushStack(dir);
        return dir;
    }

    private void pushStack(File dir) {
        this.dirIteratorStack.add(Arrays.stream(dir.listFiles(this.dirOnly)).iterator());
    }

    private void popStack() {
        this.dirIteratorStack.remove(this.dirIteratorStack.size() - 1);
    }

    private Iterator<File> getTopIterator() {
        return this.dirIteratorStack.get(this.dirIteratorStack.size() - 1);
    }
}

