/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.file;

import com.github.euler.core.AbstractPausableSource;
import com.github.euler.core.ProcessingContext;
import com.github.euler.core.SourceListener;
import com.github.euler.file.FileTreeIterator;
import com.github.euler.file.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;

public class FileSource
extends AbstractPausableSource {
    private final int maxItemsPerYield;
    private int itemsFound;
    private Iterator<File> fileIterator;
    private URI uri;

    public FileSource(int maxItemsPerYield) {
        this.maxItemsPerYield = maxItemsPerYield;
    }

    public FileSource() {
        this.maxItemsPerYield = 100;
    }

    public void prepareScan(URI uri) {
        this.uri = uri;
        Path path = FileUtils.toPath(uri);
        this.fileIterator = path.toFile().isDirectory() ? new FileTreeIterator(path.toFile()) : Arrays.asList(path.toFile()).iterator();
    }

    public boolean doScan(SourceListener listener) throws IOException {
        while (this.fileIterator.hasNext() && this.itemsFound <= this.maxItemsPerYield) {
            ++this.itemsFound;
            File found = this.fileIterator.next();
            listener.notifyItemFound(this.uri, found.toURI(), ProcessingContext.EMPTY);
        }
        if (this.fileIterator.hasNext()) {
            this.itemsFound = 0;
        }
        return !this.fileIterator.hasNext();
    }

    public void finishScan() {
    }
}

