/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.file;

import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.actor.typed.javadsl.ReceiveBuilder;
import akka.japi.function.Function;
import com.github.euler.core.JobTaskFinished;
import com.github.euler.core.JobTaskToProcess;
import com.github.euler.core.ProcessingContext;
import com.github.euler.core.TaskCommand;
import com.github.euler.file.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;

public class BasicFilePropertiesExecution
extends AbstractBehavior<TaskCommand> {
    public static Behavior<TaskCommand> create() {
        return Behaviors.setup((Function & Serializable)context -> new BasicFilePropertiesExecution((ActorContext<TaskCommand>)context));
    }

    public BasicFilePropertiesExecution(ActorContext<TaskCommand> context) {
        super(context);
    }

    public Receive<TaskCommand> createReceive() {
        ReceiveBuilder builder = this.newReceiveBuilder();
        builder.onMessage(JobTaskToProcess.class, this::onJobTaskToProcess);
        return builder.build();
    }

    private Behavior<TaskCommand> onJobTaskToProcess(JobTaskToProcess msg) throws IOException {
        File parent = Paths.get(msg.uri).toFile();
        File file = Paths.get(msg.itemURI).toFile();
        ProcessingContext.Builder builder = ProcessingContext.builder();
        builder.metadata("name", (Object)file.getName());
        builder.metadata("size", (Object)file.length());
        builder.metadata("is-directory", (Object)file.isDirectory());
        builder.metadata("path", (Object)FileUtils.getRelativePath(parent, file));
        BasicFileAttributes fileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        builder.metadata("created-datetime", (Object)new Date(fileAttributes.creationTime().toMillis()));
        builder.metadata("last-modified-datetime", (Object)new Date(fileAttributes.lastModifiedTime().toMillis()));
        ProcessingContext ctx = builder.build();
        msg.replyTo.tell((Object)new JobTaskFinished(msg, ctx));
        return this;
    }
}

