/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.file;

import com.github.euler.common.StorageStrategy;
import com.github.euler.file.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;

public class FileStorageStrategy
implements StorageStrategy {
    private final File root;
    private final String suffix;

    public FileStorageStrategy(File root, String suffix) {
        this.root = root;
        this.suffix = suffix;
    }

    public URI createFile(URI uri) {
        String baseName = FilenameUtils.getBaseName((String)FileUtils.toFile(uri).getAbsolutePath());
        return this.createFile(baseName, this.suffix);
    }

    public URI createFile(String baseName, String suffix) {
        String uuid = UUID.randomUUID().toString();
        File dir = new File(this.root, uuid.substring(0, 1) + "/" + uuid.substring(1, 2));
        dir.mkdirs();
        String name = uuid + "-" + baseName + suffix;
        File file = new File(dir, name);
        try {
            file.createNewFile();
            return file.toURI();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public URI createFile(String suffix) {
        return this.createFile("", suffix);
    }
}

