/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.elasticsearch;

import com.github.euler.common.AbstractBatchTask;
import com.github.euler.common.CommonContext;
import com.github.euler.core.JobTaskToProcess;
import com.github.euler.elasticsearch.ElasticsearchMetadataSink;
import com.github.euler.tika.FlushConfig;
import com.github.euler.tika.MetadataBatch;
import com.github.euler.tika.MetadataBatchSink;
import java.util.Objects;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticsearchMetadataTask
extends AbstractBatchTask {
    private ElasticsearchMetadataTask(String name, String index, RestHighLevelClient client, FlushConfig flushConfig) {
        super(name, () -> new MetadataBatch((MetadataBatchSink)new ElasticsearchMetadataSink(client, index, flushConfig)));
    }

    public boolean accept(JobTaskToProcess msg) {
        return (Boolean)msg.ctx.context(CommonContext.INDEXABLE, (Object)true);
    }

    public static Builder builder(String name, RestHighLevelClient client) {
        return new Builder(name, client);
    }

    public static class Builder {
        private String name;
        private String index = null;
        private RestHighLevelClient client;
        private FlushConfig flushConfig = new FlushConfig();

        private Builder(String name, RestHighLevelClient client) {
            this.name = name;
            this.client = client;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getIndex() {
            return this.index;
        }

        public Builder setIndex(String index) {
            this.index = index;
            return this;
        }

        public RestHighLevelClient getClient() {
            return this.client;
        }

        public Builder setClient(RestHighLevelClient client) {
            this.client = client;
            return this;
        }

        public FlushConfig getFlushConfig() {
            return this.flushConfig;
        }

        public Builder setFlushConfig(FlushConfig flushConfig) {
            this.flushConfig = flushConfig;
            return this;
        }

        public ElasticsearchMetadataTask build() {
            Objects.requireNonNull(this.name, () -> "name is required");
            Objects.requireNonNull(this.client, () -> "client is required");
            Objects.requireNonNull(this.flushConfig, () -> "flushConfig is required");
            return new ElasticsearchMetadataTask(this.name, this.index, this.client, this.flushConfig);
        }
    }
}

