/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.elasticsearch;

import com.github.euler.common.CommonContext;
import com.github.euler.common.SizeUtils;
import com.github.euler.core.ProcessingContext;
import com.github.euler.elasticsearch.ElasticsearchResponse;
import com.github.euler.tika.EmptyResponse;
import com.github.euler.tika.FlushConfig;
import com.github.euler.tika.MetadataBatchSink;
import com.github.euler.tika.SinkResponse;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchMetadataSink
implements MetadataBatchSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchMetadataSink.class);
    private final RestHighLevelClient client;
    private final FlushConfig flushConfig;
    private BulkRequest bulkRequest;
    private String globalIndex;
    private String index;

    public ElasticsearchMetadataSink(RestHighLevelClient client, String index, FlushConfig flushConfig) {
        this.client = client;
        this.globalIndex = index;
        this.flushConfig = flushConfig;
        this.bulkRequest = new BulkRequest();
    }

    public SinkResponse store(URI uri, ProcessingContext ctx) {
        this.index = ctx.context().containsKey(CommonContext.INDEX) ? (String)ctx.context(CommonContext.INDEX) : this.globalIndex;
        Map<String, Object> metadata = this.buildSource(ctx);
        IndexRequest req = new IndexRequest(this.index);
        String id = this.generateId(uri, ctx);
        req.id(id);
        req.source(metadata);
        this.add(req);
        return this.flush(id, false);
    }

    protected Map<String, Object> buildSource(ProcessingContext ctx) {
        HashMap<String, Object> metadata = new HashMap<String, Object>(ctx.metadata());
        return metadata;
    }

    protected String generateId(URI uri, ProcessingContext ctx) {
        return DigestUtils.md5Hex((String)uri.toString()).toLowerCase();
    }

    protected void add(IndexRequest req) {
        this.bulkRequest.add(req);
    }

    public SinkResponse flush(boolean force) {
        return this.flush(null, force);
    }

    protected SinkResponse flush(String id, boolean force) {
        int actions = this.bulkRequest.numberOfActions();
        long bytes = this.bulkRequest.estimatedSizeInBytes();
        boolean aboveMinimum = this.flushConfig.isAboveMinimum(actions, bytes);
        boolean aboveMaximum = this.flushConfig.isAboveMaximum(actions, bytes);
        if (actions > 0 && force && aboveMinimum || !force && aboveMaximum) {
            try {
                BulkResponse response = this.flush();
                this.bulkRequest = new BulkRequest();
                return new ElasticsearchResponse(id, response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new EmptyResponse(id);
    }

    private BulkResponse flush() throws IOException {
        int actions = this.bulkRequest.numberOfActions();
        if (actions > 0) {
            long bytes = this.bulkRequest.estimatedSizeInBytes();
            String size = SizeUtils.humanReadableByteCount((long)bytes, (boolean)true);
            LOGGER.info("Executing bulk request with {} actions and {}.", (Object)actions, (Object)size);
            return this.client.bulk(this.bulkRequest, RequestOptions.DEFAULT);
        }
        return null;
    }

    public void finish() {
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.stopClient();
        }
    }

    private void stopClient() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                LOGGER.error("Error closing {}.", (Object)this.client.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    protected String getIndex() {
        return this.index;
    }
}

