/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.elasticsearch;

import com.github.euler.common.StreamFactory;
import com.github.euler.configuration.ConfigContext;
import com.github.euler.configuration.TasksConfigConverter;
import com.github.euler.configuration.TypesConfigConverter;
import com.github.euler.core.Task;
import com.github.euler.elasticsearch.AbstractElasticsearchTaskConfigConverter;
import com.github.euler.elasticsearch.ElasticsearchContentTask;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticsearchFragmentTaskConfigConverter
extends AbstractElasticsearchTaskConfigConverter {
    private static final String FRAGMENT_SIZE = "fragment-size";
    private static final String FRAGMENT_OVERLAP = "fragment-overlap";

    public String type() {
        return "elasticsearch-fragment-sink";
    }

    public Task convert(Config config, ConfigContext ctx, TypesConfigConverter typeConfigConverter, TasksConfigConverter tasksConfigConverter) {
        config = config.withFallback((ConfigMergeable)this.getDefaultConfig());
        String name = this.getName(config, tasksConfigConverter);
        StreamFactory streamFactory = (StreamFactory)ctx.getRequired(StreamFactory.class);
        RestHighLevelClient client = this.getClient(config, ctx);
        ElasticsearchContentTask.Builder builder = ElasticsearchContentTask.builder(name, streamFactory, client);
        builder.setParser((Parser)ctx.get(Parser.class, (Object)new AutoDetectParser()));
        builder.setFragmentSize(config.getInt(FRAGMENT_SIZE));
        builder.setFragmentOverlap(config.getInt(FRAGMENT_OVERLAP));
        builder.setFlushConfig(this.getFlushConfig(config));
        builder.setIndex(this.getIndex(config));
        return builder.build();
    }
}

