/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.elasticsearch;

import com.github.euler.core.ProcessingContext;
import com.github.euler.elasticsearch.ElasticsearchMetadataSink;
import com.github.euler.tika.FlushConfig;
import com.github.euler.tika.FragmentBatchSink;
import com.github.euler.tika.SinkResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticsearchFragmentSink
extends ElasticsearchMetadataSink
implements FragmentBatchSink {
    public ElasticsearchFragmentSink(RestHighLevelClient client, String index, FlushConfig flushConfig) {
        super(client, index, flushConfig);
    }

    @Override
    protected Map<String, Object> buildSource(ProcessingContext ctx) {
        HashMap<String, Object> metadata = new HashMap<String, Object>(super.buildSource(ctx));
        metadata.put("join_field", "item");
        return metadata;
    }

    public SinkResponse storeFragment(String parentId, int fragIndex, String fragment) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("content", fragment);
        data.put("size", fragment.length());
        data.put("index", fragIndex);
        HashMap<String, String> joinField = new HashMap<String, String>(2);
        joinField.put("name", "fragment");
        joinField.put("parent", parentId);
        data.put("join_field", joinField);
        String fragId = UUID.randomUUID().toString();
        IndexRequest req = new IndexRequest(this.getIndex());
        req.routing(parentId);
        req.id(fragId);
        req.source(data);
        this.add(req);
        return this.flush(fragId, false);
    }
}

