/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.common;

import com.github.euler.common.FragmentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FragmentParserContentHandler
extends DefaultHandler {
    private StringBuilder builder;
    private StringBuilder nextFragmentBuilder;
    private FragmentHandler listener;
    private int fragmentSize;
    private int maxLength;

    public FragmentParserContentHandler(FragmentHandler listener) {
        this(1000, 50, listener);
    }

    public FragmentParserContentHandler(int fragmentSize, int fragmentOverlap, FragmentHandler listener) {
        this.fragmentSize = fragmentSize;
        this.maxLength = fragmentSize + fragmentOverlap;
        this.listener = listener;
    }

    @Override
    public void startDocument() throws SAXException {
        this.builder = new StringBuilder();
        this.nextFragmentBuilder = new StringBuilder();
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        for (char c : chars) {
            if (c == '\u0000') continue;
            this.builder.append(c);
            if (this.builder.length() > this.fragmentSize) {
                this.nextFragmentBuilder.append(c);
            }
            if (this.builder.length() < this.maxLength) continue;
            this.newFragmentFound();
            this.builder = this.nextFragmentBuilder;
            this.nextFragmentBuilder = new StringBuilder();
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.builder.length() > 0) {
            this.newFragmentFound();
        }
    }

    private void newFragmentFound() {
        this.listener.handleFragment(this.builder.toString().replaceAll("\u0000", " "));
    }
}

