/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.common;

import com.github.euler.core.AbstractBarrierCondition;
import com.github.euler.core.ProcessingContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateOrSizeModificationCondition
extends AbstractBarrierCondition {
    private static final Date EPOCH = new Date(Long.MIN_VALUE);
    private final String dateFormat;
    private final SimpleDateFormat sdf;

    public DateOrSizeModificationCondition(String dateFormat, Locale dateLocale) {
        this.dateFormat = dateFormat;
        if (!dateFormat.equals("date")) {
            this.sdf = new SimpleDateFormat(dateFormat, dateLocale);
            this.sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            this.sdf = null;
        }
    }

    protected boolean block(ProcessingContext ctx) {
        try {
            return this.isSizeEquals(ctx) && this.isLastModifiedDateEquals(ctx) && this.isCreatedDateEquals(ctx);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSizeEquals(ProcessingContext ctx) {
        Long oldSize = ((Integer)ctx.context("size", (Object)-1)).longValue();
        Long currentSize = (Long)ctx.metadata("size", (Object)0L);
        return oldSize.equals(currentSize);
    }

    private boolean isDateEquals(ProcessingContext ctx, String key) throws ParseException {
        Long oldValue = this.getDateAsLong(ctx, key);
        Long currentValue = ((Date)ctx.metadata(key, (Object)new Date())).getTime();
        return oldValue.equals(currentValue);
    }

    protected long getDateAsLong(ProcessingContext ctx, String key) throws ParseException {
        if (this.dateFormat.equals("date")) {
            return ((Date)ctx.context(key, (Object)EPOCH)).getTime();
        }
        if (ctx.context().containsKey(key)) {
            return this.sdf.parse((String)ctx.context(key)).getTime();
        }
        return EPOCH.getTime();
    }

    private boolean isLastModifiedDateEquals(ProcessingContext ctx) throws ParseException {
        return this.isDateEquals(ctx, "last-modified-datetime");
    }

    private boolean isCreatedDateEquals(ProcessingContext ctx) throws ParseException {
        return this.isDateEquals(ctx, "created-datetime");
    }
}

