/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.api.security;

import com.github.euler.api.OpenDistroConfiguration;
import com.github.euler.api.security.AuthResponse;
import com.github.euler.api.security.AuthService;
import com.github.euler.opendistro.OpenDistroAuthResponse;
import com.github.euler.opendistro.OpenDistroClient;
import java.io.IOException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.client.RequestOptions;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Service;

@Service
public class OpenDistroAuthService
implements AuthService {
    private final OpenDistroConfiguration opendistroConfig;

    public OpenDistroAuthService(OpenDistroConfiguration opendistroConfig) {
        this.opendistroConfig = opendistroConfig;
    }

    public AuthResponse authenticate(String username, String password) throws IOException {
        OpenDistroClient client = null;
        try {
            client = this.opendistroConfig.startClient(username, password);
            OpenDistroAuthResponse resp = client.authInfo().authInfo(RequestOptions.DEFAULT);
            if (resp != null) {
                OpenDistroAuthResponse openDistroAuthResponse = resp;
                return openDistroAuthResponse;
            }
            try {
                throw new BadCredentialsException(username + " not authorized.");
            }
            catch (ElasticsearchStatusException e) {
                throw new BadCredentialsException(username + " not authorized.");
            }
            catch (IOException e) {
                throw new AuthenticationServiceException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

