/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.api.persistence;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.euler.api.APIConfiguration;
import com.github.euler.api.model.Template;
import com.github.euler.api.model.TemplateList;
import com.github.euler.api.persistence.AbstractTemplatePersistence;
import com.github.euler.api.persistence.TemplatesPersistence;
import com.github.euler.opendistro.OpenDistroClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ESTemplatesPersistence
extends AbstractTemplatePersistence
implements TemplatesPersistence {
    private final ObjectMapper objectMapper;

    @Autowired
    public ESTemplatesPersistence(OpenDistroClient client, APIConfiguration configuration, ObjectMapper objectMapper) {
        super(client, configuration);
        this.objectMapper = objectMapper.copy().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public TemplateList list(Integer page, Integer size, String name) throws IOException {
        SearchRequest req = new SearchRequest(new String[]{this.getTemplateIndex()});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder query = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{name})).minimumShouldMatch(1);
        if (name != null && !name.isBlank()) {
            query.should((QueryBuilder)QueryBuilders.matchQuery((String)"name", (Object)name));
        }
        searchSourceBuilder.query((QueryBuilder)query);
        searchSourceBuilder.size(size.intValue());
        searchSourceBuilder.from(page * size);
        SearchResponse response = this.client.search(req, RequestOptions.DEFAULT);
        int total = Long.valueOf(response.getHits().getTotalHits().value).intValue();
        List templates = Arrays.stream(response.getHits().getHits()).map(h -> this.convert(h)).collect(Collectors.toList());
        TemplateList list = new TemplateList();
        list.setTotal(Integer.valueOf(total));
        list.setTemplates(templates);
        return list;
    }

    protected Template convert(SearchHit h) {
        Map source = h.getSourceAsMap();
        return (Template)this.objectMapper.convertValue((Object)source, Template.class);
    }
}

