/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.api.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.euler.api.APIConfiguration;
import com.github.euler.api.model.TemplateDetails;
import com.github.euler.api.persistence.AbstractTemplatePersistence;
import com.github.euler.api.persistence.TemplatePersistence;
import com.github.euler.opendistro.OpenDistroClient;
import com.typesafe.config.ConfigRenderOptions;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.xcontent.XContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"com.github.euler.api.WaitElasticsearchBean"})
public class ESTemplatePersistence
extends AbstractTemplatePersistence
implements TemplatePersistence {
    private final ObjectMapper objectMapper;
    private final ObjectWriter writer;
    private final ObjectReader reader;

    @Autowired
    public ESTemplatePersistence(OpenDistroClient client, APIConfiguration configuration, ObjectMapper objectMapper) {
        super(client, configuration);
        this.objectMapper = objectMapper;
        this.writer = this.objectMapper.writerFor(TemplateDetails.class);
        this.reader = this.objectMapper.readerFor(TemplateDetails.class);
    }

    @PostConstruct
    protected void initializeJobIndex() throws IOException {
        boolean autoInitialize = this.configuration.getConfig().getBoolean("euler.http-api.elasticsearch.auto-initialize-indices");
        if (autoInitialize) {
            String jsonMapping = this.configuration.getConfig().getConfig("euler.http-api.elasticsearch.template-index.mappings").root().render(ConfigRenderOptions.concise());
            this.initializeIndex(this.getTemplateIndex(), jsonMapping, RequestOptions.DEFAULT);
        }
    }

    public TemplateDetails create(TemplateDetails template) throws IOException {
        IndexRequest req = new IndexRequest(this.getTemplateIndex());
        req.id(template.getName());
        req.source(this.toBytes(template), XContentType.JSON);
        this.client.index(req, RequestOptions.DEFAULT);
        return template;
    }

    public void delete(String name) throws IOException {
        DeleteRequest req = new DeleteRequest(this.getTemplateIndex(), name);
        this.client.delete(req, RequestOptions.DEFAULT);
    }

    public TemplateDetails get(String name) throws IOException {
        GetRequest req = new GetRequest(this.getTemplateIndex(), name);
        GetResponse resp = this.client.get(req, RequestOptions.DEFAULT);
        return this.readValue(resp.getSourceAsBytes());
    }

    private byte[] toBytes(TemplateDetails template) {
        try {
            return this.writer.writeValueAsBytes((Object)template);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected TemplateDetails readValue(byte[] sourceAsBytes) throws IOException {
        return (TemplateDetails)this.reader.readValue(sourceAsBytes);
    }
}

