/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.api.persistence;

import com.github.euler.opendistro.OpenDistroClient;
import java.io.IOException;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ESPersistence {
    private static final Logger LOGGER = LoggerFactory.getLogger(ESPersistence.class);
    protected final OpenDistroClient client;

    public ESPersistence(OpenDistroClient client) {
        this.client = client;
    }

    protected void initializeIndex(String index, String jsonMapping, RequestOptions opts) throws IOException {
        if (!this.isIndexCreated(index, opts)) {
            LOGGER.info("Initiliazing index {}.", (Object)index);
            this.createIndex(index, jsonMapping, opts);
        }
    }

    protected void createIndex(String index, String jsonMapping, RequestOptions opts) throws IOException {
        CreateIndexRequest req = new CreateIndexRequest(index);
        req.mapping(jsonMapping, XContentType.JSON);
        this.client.indices().create(req, opts);
    }

    protected boolean isIndexCreated(String index, RequestOptions opts) throws IOException {
        GetIndexRequest req = new GetIndexRequest(new String[]{index});
        return this.client.indices().exists(req, opts);
    }
}

