/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.api.persistence;

import com.github.euler.api.APIConfiguration;
import com.github.euler.api.model.Job;
import com.github.euler.api.model.JobStatus;
import com.github.euler.api.model.SortBy;
import com.github.euler.api.model.SortDirection;
import com.github.euler.api.persistence.ESPersistence;
import com.github.euler.opendistro.OpenDistroClient;
import java.io.IOException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public abstract class AbstractJobPersistence<J extends Job>
extends ESPersistence {
    protected final APIConfiguration configuration;

    public AbstractJobPersistence(OpenDistroClient client, APIConfiguration configuration) {
        super(client);
        this.configuration = configuration;
    }

    protected String getJobIndex() {
        return this.configuration.getConfig().getString("euler.http-api.elasticsearch.job-index.name");
    }

    protected SearchResponse listJobs(Integer page, Integer size, SortBy sortBy, SortDirection sortDirection, JobStatus status, boolean requestCache) throws IOException {
        SearchRequest req = new SearchRequest(new String[]{this.getJobIndex()});
        req.requestCache(Boolean.valueOf(requestCache));
        Object query = status != null ? QueryBuilders.termQuery((String)"status", (Object)status) : QueryBuilders.matchAllQuery();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)query);
        searchSourceBuilder.size(size.intValue());
        searchSourceBuilder.from(page * size);
        searchSourceBuilder.sort(sortBy.toString().toLowerCase().replace('_', '-'), SortOrder.fromString((String)sortDirection.toString()));
        return this.client.search(req, RequestOptions.DEFAULT);
    }

    public J get(String id) throws IOException {
        GetRequest req = new GetRequest(this.getJobIndex(), id);
        GetResponse response = this.client.get(req, RequestOptions.DEFAULT);
        if (response.isExists()) {
            Job j = this.readValue(response.getSourceAsBytes());
            j.setId(response.getId());
            return (J)j;
        }
        return null;
    }

    protected abstract J readValue(byte[] var1) throws IOException;
}

