/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.api;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.MainResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitElasticSearchTask
implements Callable<MainResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitElasticSearchTask.class);
    private final RestHighLevelClient client;
    private int maxRetries = 30;
    private long interval = 2000L;

    public WaitElasticSearchTask(RestHighLevelClient client) {
        this.client = client;
    }

    @Override
    public MainResponse call() throws Exception {
        for (int attempts = 0; attempts < this.maxRetries; ++attempts) {
            try {
                MainResponse resp = this.client.info(RequestOptions.DEFAULT);
                LOGGER.info("Connected to Elasticsearch.");
                return resp;
            }
            catch (IOException | ElasticsearchException e) {
                LOGGER.info("Could not connect to Elasticsearch. Retry will occur in {}ms.", (Object)this.interval);
                Thread.sleep(this.interval);
                continue;
            }
        }
        throw new IllegalStateException("Could not connect to Elasticsearch.");
    }
}

