/*
 * Decompiled with CFR 0.152.
 */
package com.github.euler.api;

import com.github.euler.api.APIConfiguration;
import com.github.euler.opendistro.OpenDistroClient;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OpenDistroConfiguration {
    private final APIConfiguration configuration;
    private OpenDistroClient client;

    @Autowired
    public OpenDistroConfiguration(APIConfiguration configuraiton) {
        this.configuration = configuraiton;
    }

    @PostConstruct
    public void postConstruct() {
        this.start();
    }

    private void start() {
        String username = this.getUsername();
        String password = this.getPassword();
        this.client = this.startClient(username, password);
    }

    public OpenDistroClient startClient(String username, String password) {
        HttpHost[] hosts = this.getElasticsearchHosts();
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
        String ca = this.getCertificateAuthorities();
        builder.setHttpClientConfigCallback((RestClientBuilder.HttpClientConfigCallback)new /* Unavailable Anonymous Inner Class!! */);
        return new OpenDistroClient(builder);
    }

    private String getUsername() {
        Config config = this.configuration.getConfig();
        try {
            return config.getString("euler.http-api.elasticsearch.username");
        }
        catch (ConfigException.WrongType e) {
            return null;
        }
    }

    private String getPassword() {
        Config config = this.configuration.getConfig();
        try {
            return config.getString("euler.http-api.elasticsearch.password");
        }
        catch (ConfigException.WrongType e) {
            return null;
        }
    }

    @Bean
    public OpenDistroClient opendistroClient() {
        return this.client;
    }

    @PreDestroy
    public void preDestroy() throws IOException {
        this.stop();
    }

    private void stop() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    private HttpHost[] getElasticsearchHosts() throws ConfigException.Missing {
        Config config = this.configuration.getConfig();
        try {
            return (HttpHost[])config.getStringList("euler.http-api.elasticsearch.hosts").stream().distinct().map(h -> this.toHttpHost(h)).toArray(HttpHost[]::new);
        }
        catch (ConfigException.WrongType e) {
            return new HttpHost[]{this.toHttpHost(config.getString("elasticsearch.hosts"))};
        }
    }

    private HttpHost toHttpHost(String uriStr) {
        try {
            URI uri = new URI(uriStr);
            return new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    String getCertificateAuthorities() {
        try {
            Config config = this.configuration.getConfig();
            return config.getString("euler.http-api.elasticsearch.ssl.certificate-authorities");
        }
        catch (ConfigException.Missing e) {
            return null;
        }
    }
}

