package com.github.euler.api.persistence;

import java.io.IOException;

import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.github.euler.opendistro.OpenDistroClient;

public abstract class ESPersistence {

    private static final Logger LOGGER = LoggerFactory.getLogger(ESPersistence.class);

    protected final OpenDistroClient client;

    public ESPersistence(OpenDistroClient client) {
        super();
        this.client = client;
    }

    protected void initializeIndex(String index, String jsonMapping, RequestOptions opts) throws IOException {
        if (!isIndexCreated(index, opts)) {
            LOGGER.info("Initiliazing index {}.", index);
            createIndex(index, jsonMapping, opts);
        }
    }

    protected void createIndex(String index, String jsonMapping, RequestOptions opts) throws IOException {
        CreateIndexRequest req = new CreateIndexRequest(index);
        req.mapping(jsonMapping, XContentType.JSON);
        client.indices().create(req, opts);
    }

    protected boolean isIndexCreated(String index, RequestOptions opts) throws IOException {
        GetIndexRequest req = new GetIndexRequest(index);
        return client.indices().exists(req, opts);
    }

}
