/*
 * Decompiled with CFR 0.152.
 */
package esa.commons.netty.core;

import esa.commons.Checks;
import esa.commons.netty.core.Buffer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class BufferImpl
implements Buffer {
    static final BufferImpl EMPTY_BUFFER = new BufferImpl(Unpooled.EMPTY_BUFFER);
    private final ByteBuf underlying;

    public BufferImpl() {
        this(Unpooled.buffer());
    }

    public BufferImpl(int initialCapacity) {
        this(Unpooled.buffer((int)initialCapacity));
    }

    public BufferImpl(int initialCapacity, int maxCapacity) {
        this(Unpooled.buffer((int)initialCapacity, (int)maxCapacity));
    }

    public BufferImpl(ByteBufAllocator allocator) {
        this(allocator.buffer());
    }

    public BufferImpl(ByteBufAllocator allocator, int initialCapacity) {
        this(allocator.buffer(initialCapacity));
    }

    public BufferImpl(ByteBufAllocator allocator, int initialCapacity, int maxCapacity) {
        this(allocator.buffer(initialCapacity, maxCapacity));
    }

    public BufferImpl(ByteBuf underlying) {
        Checks.checkNotNull((Object)underlying, (String)"underlying");
        this.underlying = underlying;
    }

    @Override
    public byte getByte(int pos) {
        return this.underlying.getByte(pos);
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.underlying.getBoolean(pos);
    }

    @Override
    public char getChar(int index) {
        return this.underlying.getChar(index);
    }

    @Override
    public short getShort(int pos) {
        return this.underlying.getShort(pos);
    }

    @Override
    public int getInt(int pos) {
        return this.underlying.getInt(pos);
    }

    @Override
    public int getMedium(int pos) {
        return this.underlying.getMedium(pos);
    }

    @Override
    public long getLong(int pos) {
        return this.underlying.getLong(pos);
    }

    @Override
    public double getDouble(int pos) {
        return this.underlying.getDouble(pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.underlying.getFloat(pos);
    }

    @Override
    public byte readByte() {
        return this.underlying.readByte();
    }

    @Override
    public boolean readBoolean() {
        return this.underlying.readBoolean();
    }

    @Override
    public char readChar() {
        return this.underlying.readChar();
    }

    @Override
    public short readShort() {
        return this.underlying.readShort();
    }

    @Override
    public int readMedium() {
        return this.underlying.readMedium();
    }

    @Override
    public int readInt() {
        return this.underlying.readInt();
    }

    @Override
    public long readLong() {
        return this.underlying.readLong();
    }

    @Override
    public double readDouble() {
        return this.underlying.readDouble();
    }

    @Override
    public float readFloat() {
        return this.underlying.readFloat();
    }

    @Override
    public Buffer setByte(int pos, byte b) {
        this.underlying.setByte(pos, (int)b);
        return this;
    }

    @Override
    public Buffer setBoolean(int pos, boolean b) {
        this.underlying.setBoolean(pos, b);
        return this;
    }

    @Override
    public Buffer setChar(int index, int value) {
        this.underlying.setChar(index, value);
        return this;
    }

    @Override
    public Buffer setShort(int pos, short s) {
        this.underlying.setShort(pos, (int)s);
        return this;
    }

    @Override
    public Buffer setMedium(int pos, int i) {
        this.underlying.setMedium(pos, i);
        return this;
    }

    @Override
    public Buffer setInt(int pos, int i) {
        this.underlying.setInt(pos, i);
        return this;
    }

    @Override
    public Buffer setLong(int pos, long l) {
        this.underlying.setLong(pos, l);
        return this;
    }

    @Override
    public Buffer setDouble(int pos, double d) {
        this.underlying.setDouble(pos, d);
        return this;
    }

    @Override
    public Buffer setFloat(int pos, float f) {
        this.underlying.setFloat(pos, f);
        return this;
    }

    @Override
    public Buffer writeByte(byte b) {
        this.underlying.writeByte((int)b);
        return this;
    }

    @Override
    public Buffer writeBoolean(boolean b) {
        this.underlying.writeBoolean(b);
        return this;
    }

    @Override
    public Buffer writeChar(int b) {
        this.underlying.writeChar(b);
        return this;
    }

    @Override
    public Buffer writeShort(short s) {
        this.underlying.writeShort((int)s);
        return this;
    }

    @Override
    public Buffer writeMedium(int s) {
        this.underlying.writeMedium(s);
        return this;
    }

    @Override
    public Buffer writeInt(int i) {
        this.underlying.writeInt(i);
        return this;
    }

    @Override
    public Buffer writeLong(long l) {
        this.underlying.writeLong(l);
        return this;
    }

    @Override
    public Buffer writeDouble(double d) {
        this.underlying.writeDouble(d);
        return this;
    }

    @Override
    public Buffer writeFloat(float f) {
        this.underlying.writeFloat(f);
        return this;
    }

    @Override
    public Buffer getBytes(int index, byte[] dst) {
        this.underlying.getBytes(index, dst);
        return this;
    }

    @Override
    public Buffer getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.underlying.getBytes(index, dst, dstIndex, length);
        return this;
    }

    @Override
    public Buffer readBytes(byte[] dst) {
        this.underlying.readBytes(dst);
        return this;
    }

    @Override
    public Buffer readBytes(byte[] dst, int dstIndex, int length) {
        this.underlying.readBytes(dst, dstIndex, length);
        return this;
    }

    @Override
    public Buffer setBytes(int index, byte[] src) {
        this.underlying.setBytes(index, src);
        return this;
    }

    @Override
    public Buffer setBytes(int index, byte[] src, int srcIndex, int length) {
        this.underlying.setBytes(index, src, srcIndex, length);
        return this;
    }

    @Override
    public Buffer writeBytes(byte[] src) {
        this.underlying.writeBytes(src);
        return this;
    }

    @Override
    public Buffer writeBytes(byte[] src, int srcIndex, int length) {
        this.underlying.writeBytes(src, srcIndex, length);
        return this;
    }

    @Override
    public int capacity() {
        return this.underlying.capacity();
    }

    @Override
    public int writerIndex() {
        return this.underlying.writerIndex();
    }

    @Override
    public int readerIndex() {
        return this.underlying.readerIndex();
    }

    @Override
    public boolean isReadable() {
        return this.underlying.isReadable();
    }

    @Override
    public boolean isReadable(int size) {
        return this.underlying.isReadable(size);
    }

    @Override
    public boolean isWritable() {
        return this.underlying.isWritable();
    }

    @Override
    public boolean isWritable(int size) {
        return this.underlying.isWritable(size);
    }

    @Override
    public int readableBytes() {
        return this.underlying.readableBytes();
    }

    @Override
    public int writableBytes() {
        return this.underlying.writableBytes();
    }

    @Override
    public int maxWritableBytes() {
        return this.underlying.maxWritableBytes();
    }

    @Override
    public Buffer clear() {
        this.underlying.clear();
        return this;
    }

    @Override
    public Buffer copy() {
        return new BufferImpl(this.underlying.copy());
    }

    @Override
    public Buffer slice() {
        return new BufferImpl(this.underlying.slice());
    }

    @Override
    public Buffer slice(int start, int length) {
        return new BufferImpl(this.underlying.slice(start, length));
    }

    @Override
    public ByteBuf getByteBuf() {
        return this.underlying;
    }

    @Override
    public String string(Charset charset) {
        return this.underlying.toString(StandardCharsets.UTF_8);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferImpl buffer1 = (BufferImpl)o;
        return Objects.equals(this.underlying, buffer1.underlying);
    }

    public String toString() {
        return this.underlying.toString();
    }

    public int hashCode() {
        return this.underlying.hashCode();
    }
}

