/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart;

import com.google.common.collect.ImmutableSet;
import com.google.dart.DartMojo;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.cli.Arg;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.WriterStreamConsumer;

@Mojo(name="test", threadSafe=true, defaultPhase=LifecyclePhase.TEST)
public class TestMojo
extends DartMojo {
    @Parameter
    private Set<String> includes = new HashSet<String>();
    @Parameter
    private final Set<String> excludes = new HashSet<String>();
    @Parameter(property="skipTests")
    private boolean skipTests;
    @Parameter(property="failIfNoTests", defaultValue="false")
    private boolean failIfNoTests;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<File> dartPackageRoots = this.findDartPackageRoots();
        this.processPubDependencies(dartPackageRoots);
        if (this.isSkipTests()) {
            this.getLog().info((CharSequence)"Tests are skipped.");
        } else {
            this.executeTests(dartPackageRoots);
        }
    }

    private void executeTests(Set<File> dartPackageRoots) throws MojoExecutionException, MojoFailureException {
        Commandline cl = this.createBaseCommandline();
        Arg scriptArg = cl.createArg(true);
        WriterStreamConsumer output = new WriterStreamConsumer((Writer)new OutputStreamWriter(System.out));
        WriterStreamConsumer error = new WriterStreamConsumer((Writer)new OutputStreamWriter(System.err));
        Set<File> testSources = this.computeTestToRun(dartPackageRoots);
        System.out.println();
        System.out.println();
        boolean fail = false;
        for (File dartTestFile : testSources) {
            try {
                scriptArg.setValue(dartTestFile.getAbsolutePath());
                this.getLog().info((CharSequence)("Execute test: " + dartTestFile.getAbsolutePath()));
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Execute test command: " + cl.toString()));
                }
                int returnValue = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)output, (StreamConsumer)error);
                System.out.println();
                System.out.println();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("test return code: " + returnValue));
                }
                if (returnValue != 0 && returnValue != 255) {
                    throw new MojoExecutionException("Test fail returned error code " + returnValue);
                }
                if (returnValue != 255) continue;
                fail = true;
            }
            catch (CommandLineException e) {
                this.getLog().error((CharSequence)"error running tests: ", (Throwable)e);
                fail = true;
            }
        }
        this.reportExecution(testSources, fail);
        System.out.println();
        System.out.println();
    }

    private void reportExecution(Set<File> testSources, boolean fail) throws MojoFailureException {
        if (testSources.isEmpty()) {
            if (this.isFailIfNoTests()) {
                return;
            }
            throw new MojoFailureException("No tests were executed!  (Set -DfailIfNoTests=false to ignore this error.)");
        }
        if (fail) {
            String msg = "There are test failures.\n\nPlease refer to output for the individual test results.";
            if (this.isTestFailureIgnore()) {
                this.getLog().error((CharSequence)msg);
            } else {
                throw new MojoFailureException(msg);
            }
        }
    }

    public Set<String> getIncludes() {
        if (this.includes.isEmpty()) {
            return ImmutableSet.copyOf(Arrays.asList("test/**/*.dart"));
        }
        return this.includes;
    }

    protected Set<String> getExcludes() {
        if (this.excludes.isEmpty()) {
            return ImmutableSet.copyOf(Arrays.asList("test/**/packages/**"));
        }
        return this.excludes;
    }

    private Set<File> computeTestToRun(Set<File> packageRoots) throws MojoExecutionException {
        HashSet<File> testToRun = new HashSet<File>();
        for (File packageRoot : packageRoots) {
            testToRun.addAll(this.scanForTests(packageRoot, this.getIncludes(), this.getExcludes()));
        }
        return testToRun;
    }

    private Set<File> scanForTests(File sourceDir, Set<String> sourceIncludes, Set<String> sourceExcludes) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setFollowSymlinks(true);
        ds.setBasedir(sourceDir);
        String[] includes = sourceIncludes.isEmpty() ? new String[]{} : sourceIncludes.toArray(new String[sourceIncludes.size()]);
        ds.setIncludes(includes);
        String[] excludes = sourceExcludes.isEmpty() ? new String[]{} : sourceExcludes.toArray(new String[sourceExcludes.size()]);
        ds.setExcludes(excludes);
        ds.addDefaultExcludes();
        ds.scan();
        String[] potentialSources = ds.getIncludedFiles();
        HashSet<File> matchingSources = new HashSet<File>(potentialSources != null ? potentialSources.length : 0);
        if (potentialSources != null) {
            for (String potentialSource : potentialSources) {
                matchingSources.add(new File(sourceDir, potentialSource));
            }
        }
        return matchingSources;
    }

    public boolean isFailIfNoTests() {
        return this.failIfNoTests;
    }

    public boolean isTestFailureIgnore() {
        return this.testFailureIgnore;
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }
}

