/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart;

import com.google.dart.AbstractDartMojo;
import com.google.dart.util.OsUtil;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.WriterStreamConsumer;

@Mojo(name="pub", threadSafe=true)
public class PubMojo
extends AbstractDartMojo {
    @Parameter(defaultValue="get", property="dart.pub.command")
    private String pubCommand;
    @Parameter
    private List<String> pubOptions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<File> dartPackageRoots = this.findDartPackageRoots();
        this.processPubDependencies(dartPackageRoots);
    }

    protected void processPubDependencies(Set<File> dartPackageRoots) throws MojoExecutionException {
        if (this.isPubSkipped()) {
            this.getLog().info((CharSequence)"Updating dependencies (pub packagemanager) is skipped.");
            return;
        }
        this.checkPub();
        String pubPath = this.getPubExecutable().getAbsolutePath();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Using pub '" + pubPath + "'."));
            this.getLog().debug((CharSequence)("basedir: " + this.getBasedir()));
        }
        WriterStreamConsumer output = new WriterStreamConsumer((Writer)new OutputStreamWriter(System.out));
        WriterStreamConsumer error = new WriterStreamConsumer((Writer)new OutputStreamWriter(System.err));
        Commandline cl = new Commandline();
        cl.setExecutable(pubPath);
        cl.createArg().setValue(this.pubCommand);
        if (this.pubOptions != null) {
            for (String option : this.pubOptions) {
                cl.createArg().setValue(option);
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Base pub command: " + cl.toString()));
        }
        System.out.println();
        System.out.println();
        try {
            for (File dartPackageRoot : dartPackageRoots) {
                this.getLog().info((CharSequence)("Run pub for package root: " + this.relativePath(dartPackageRoot)));
                cl.setWorkingDirectory(dartPackageRoot);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Execute pub command: " + cl.toString()));
                }
                int returnCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)output, (StreamConsumer)error);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("pub return code: " + returnCode));
                }
                if (returnCode == 0) continue;
                throw new MojoExecutionException("Pub returned error code " + returnCode);
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute pub", (Exception)((Object)e));
        }
        System.out.println();
        System.out.println();
    }

    protected void checkPub() throws MojoExecutionException {
        this.checkDartSdk();
        if (!this.getPubExecutable().canExecute()) {
            throw new MojoExecutionException("Pub not executable! Configuration error for dartSdk? dartSdk=" + this.getDartSdk().getAbsolutePath());
        }
    }

    private File getPubExecutable() {
        return new File(this.getDartSdk(), "bin/pub" + (OsUtil.isWindows() ? ".bat" : ""));
    }

    public boolean isPubSkipped() {
        return false;
    }
}

