/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart;

import com.google.common.base.Throwables;
import com.google.dart.DartMojo;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.WriterStreamConsumer;

@Mojo(name="dwc", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class DartWebMojo
extends DartMojo {
    private static final String ARGUMENT_OUT = "--out";
    @Parameter(property="output", defaultValue="${project.build.directory}/generated-sources/dwc")
    private File outputDir;
    @Parameter(property="htmlFile", defaultValue="web/index.html")
    private String htmlFile;
    @Parameter(property="dwcScript", defaultValue="packages/web_ui/dwc.dart")
    private String dwcScript;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<File> dartPackageRoots = this.findDartPackageRoots();
        this.processPubDependencies(dartPackageRoots);
        this.checkDart();
        String dartPath = this.getDartExecutable().getAbsolutePath();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Using dart '" + dartPath + "'."));
        }
        Commandline cl = new Commandline();
        cl.setExecutable(dartPath);
        cl.createArg().setValue(this.buildPackagePath());
        File dwc = new File(this.sourceDirectory, this.dwcScript);
        if (!dwc.exists()) {
            throw new MojoExecutionException("The dwc script does not exist here: " + dwc.getAbsolutePath());
        }
        cl.createArg().setValue(dwc.getAbsolutePath());
        try {
            FileUtils.deleteDirectory((File)this.outputDir);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.outputDir.mkdirs();
        cl.createArg().setValue(ARGUMENT_OUT);
        cl.createArg().setValue(this.outputDir.getAbsolutePath());
        File html = new File(this.sourceDirectory, this.htmlFile);
        if (!html.exists()) {
            throw new MojoExecutionException("The HTML file does not exist here: " + html.getAbsolutePath());
        }
        cl.createArg().setValue(html.getAbsolutePath());
        WriterStreamConsumer output = new WriterStreamConsumer((Writer)new OutputStreamWriter(System.out));
        WriterStreamConsumer error = new WriterStreamConsumer((Writer)new OutputStreamWriter(System.err));
        this.getLog().info((CharSequence)("Execute dart: " + cl.toString()));
        System.out.println();
        System.out.println();
        try {
            int returnValue = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)output, (StreamConsumer)error);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("dart return code: " + returnValue));
            }
            if (returnValue != 0) {
                throw new MojoExecutionException("Dart returned error code " + returnValue);
            }
        }
        catch (CommandLineException e) {
            this.getLog().debug((CharSequence)"dart error: ", (Throwable)e);
        }
        System.out.println();
        System.out.println();
    }
}

