/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart;

import com.google.dart.PubMojo;
import com.google.dart.util.OsUtil;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.WriterStreamConsumer;

@Mojo(name="dart", threadSafe=true)
public class DartMojo
extends PubMojo {
    private static final String ARGUMENT_CHECKED_MODE = "--checked";
    protected static final String ARGUMENT_PACKAGE_PATH = "--package-root=";
    private static final String ARGUMENT_DEBUG = "--debug";
    private static final String ARGUMENT_BREAK_AT = "--break_at=";
    private static final String ARGUMENT_USE_SCRIPT_SNAPSHOT = "--use_script_snapshot=";
    @Parameter(property="script")
    private File script;
    @Parameter(defaultValue="false", property="dart.checkedMode")
    private boolean checkedMode;
    @Parameter(defaultValue="packages", property="dart.packagePath")
    private String packagePath;
    @Parameter(defaultValue="false", property="dart.debug")
    private boolean debug;
    @Parameter(property="dart.debugPort")
    private String debugPort;
    @Parameter(property="dart.breakAt")
    private String breakAt;
    @Parameter(property="dart.useScriptSnapshot")
    private String useScriptSnapshot;
    @Parameter(defaultValue="false", property="dart.pup.skip")
    private boolean skipPub;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<File> dartPackageRoots = this.findDartPackageRoots();
        this.processPubDependencies(dartPackageRoots);
        this.executeDart();
    }

    private void executeDart() throws MojoExecutionException {
        Commandline cl = this.createBaseCommandline();
        if (this.script == null) {
            throw new NullPointerException("Script is required but is null.");
        }
        if (!this.script.exists() || !this.script.isFile()) {
            throw new IllegalArgumentException("Script must be a file. scripte=" + this.script.getAbsolutePath());
        }
        if (!this.script.canRead()) {
            throw new IllegalArgumentException("Script must be a readable file. scripte=" + this.script.getAbsolutePath());
        }
        cl.createArg(true).setValue(this.script.getAbsolutePath());
        WriterStreamConsumer output = new WriterStreamConsumer((Writer)new OutputStreamWriter(System.out));
        WriterStreamConsumer error = new WriterStreamConsumer((Writer)new OutputStreamWriter(System.err));
        this.getLog().info((CharSequence)("Execute dart: " + cl.toString()));
        System.out.println();
        System.out.println();
        try {
            int returnValue = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)output, (StreamConsumer)error);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("dart return code: " + returnValue));
            }
            if (returnValue != 0) {
                throw new MojoExecutionException("Dart returned error code " + returnValue);
            }
        }
        catch (CommandLineException e) {
            this.getLog().debug((CharSequence)"dart error: ", (Throwable)e);
        }
        System.out.println();
        System.out.println();
    }

    protected Commandline createBaseCommandline() throws MojoExecutionException {
        this.checkDart();
        String dartPath = this.getDartExecutable().getAbsolutePath();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Using dart '" + dartPath + "'."));
        }
        Commandline cl = new Commandline();
        cl.setExecutable(dartPath);
        if (this.isCheckedMode()) {
            cl.createArg().setValue(ARGUMENT_CHECKED_MODE);
        }
        if (this.isDebug()) {
            cl.createArg().setValue(ARGUMENT_DEBUG + (this.isDebugPort() ? ":" + this.debugPort : ""));
        }
        if (this.isBreakAt()) {
            cl.createArg().setValue(ARGUMENT_BREAK_AT + this.breakAt);
        }
        if (this.isUseScriptSnapshot()) {
            cl.createArg().setValue(ARGUMENT_USE_SCRIPT_SNAPSHOT + this.useScriptSnapshot);
        }
        cl.createArg().setValue(this.buildPackagePath());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Base dart command: " + cl.toString()));
        }
        return cl;
    }

    protected void checkDart() throws MojoExecutionException {
        this.checkDartSdk();
        if (!this.getDartExecutable().canExecute()) {
            throw new MojoExecutionException("Dart not executable! Configuration error for dartSdk? dartSdk=" + this.getDartSdk().getAbsolutePath());
        }
    }

    protected File getDartExecutable() {
        return new File(this.getDartSdk(), "bin/dart" + (OsUtil.isWindows() ? ".exe" : ""));
    }

    protected String buildPackagePath() {
        StringBuilder sb = new StringBuilder(ARGUMENT_PACKAGE_PATH);
        sb.append(new File(this.sourceDirectory, this.packagePath).getAbsolutePath());
        sb.append(File.separator);
        return sb.toString();
    }

    @Override
    public boolean isPubSkipped() {
        return this.skipPub;
    }

    protected boolean isCheckedMode() {
        return this.checkedMode;
    }

    protected boolean isDebug() {
        return this.debug;
    }

    protected boolean isDebugPort() {
        return !StringUtils.isEmpty((String)this.debugPort);
    }

    protected boolean isBreakAt() {
        return !StringUtils.isEmpty((String)this.breakAt);
    }

    protected boolean isUseScriptSnapshot() {
        return !StringUtils.isEmpty((String)this.useScriptSnapshot);
    }
}

