/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart;

import com.google.common.collect.ImmutableSet;
import com.google.dart.PubMojo;
import com.google.dart.util.OsUtil;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.cli.Arg;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.WriterStreamConsumer;

@Mojo(name="dart2js", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class Dart2JsMojo
extends PubMojo {
    private static final String ARGUMENT_CHECKED_MODE = "-c";
    private static final String ARGUMENT_OUTPUT_FILE = "-o";
    private static final String ARGUMENT_PACKAGE_PATH = "-p";
    private static final String ARGUMENT_VERBOSE = "-v";
    private static final String ARGUMENT_ANALYSE_ALL = "--analyze-all";
    private static final String ARGUMENT_MINIFY = "--minify";
    private static final String ARGUMENT_SUPPRESS_WARNINGS = "--suppress-warnings";
    private static final String ARGUMENT_SUPPRESS_HINTS = "--suppress-hints";
    private static final String ARGUMENT_DIAGNOSTIC_COLORS = "--enable-diagnostic-colors";
    private static final String ARGUMENT_GLOBAL_JS_NAME = "--global-js-name=";
    @Parameter(defaultValue="false", property="dart.skip")
    private boolean skipDart2Js;
    @Parameter(defaultValue="false", property="dart.checkedMode")
    private boolean checkedMode;
    @Parameter(defaultValue="false", property="dart.verbose")
    private boolean verbose;
    @Parameter(defaultValue="false", property="dart.analyseAll")
    private boolean analyseAll;
    @Parameter(defaultValue="false", property="dart.minify")
    private boolean minify;
    @Parameter(defaultValue="false", property="dart.suppressWarnings")
    private boolean suppressWarnings;
    @Parameter(defaultValue="false", property="dart.suppressHints")
    private boolean suppressHints;
    @Parameter(defaultValue="false", property="dart.diagnosticColors")
    private boolean diagnosticColors;
    @Parameter(property="dart.packagepath")
    private File packagePath;
    @Parameter(defaultValue="false", property="dart.force")
    private boolean force;
    @Parameter(defaultValue="${project.build.directory}/dart", required=true, property="dart.outputDirectory")
    private File outputDirectory;
    @Parameter
    private Set<String> includes = new HashSet<String>();
    @Parameter
    private final Set<String> excludes = new HashSet<String>();
    @Parameter(property="lastModGranularityMs", defaultValue="0")
    private int staleMillis;
    @Parameter(defaultValue="false", property="dart.pup.skip")
    private boolean skipPub;
    @Parameter(defaultValue="$", property="dart.global.js.name")
    private String globalJsName;
    @Parameter(defaultValue="1", property="dart.thread.count")
    private int threadCount;
    @Parameter(defaultValue="0", property="dart.thread.timeout")
    private int timeout;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.isSkipDart2Js()) {
            this.getLog().info((CharSequence)"skipping dart2js execution");
            return;
        }
        Set<File> dartPackageRoots = this.findDartPackageRoots();
        this.processPubDependencies(dartPackageRoots);
        this.processDart2Js(dartPackageRoots);
    }

    private void processDart2Js(Set<File> dartPackageRoots) throws MojoExecutionException {
        if (this.isForce()) {
            this.clearOutputDirectory();
        }
        Set<File> staleDartSources = this.computeStaleSources(dartPackageRoots, this.getSourceInclusionScanner());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("staleMillis: " + this.staleMillis));
            this.getLog().debug((CharSequence)("basedir: " + this.getBasedir()));
            this.getLog().debug((CharSequence)("outputDirectory: " + this.outputDirectory));
            this.getLog().debug((CharSequence)"Source includes:");
            for (String include : this.getIncludes()) {
                this.getLog().debug((CharSequence)(" " + include));
            }
            this.getLog().debug((CharSequence)"Source excludes:");
            for (String exclude : this.getExcludes()) {
                this.getLog().debug((CharSequence)(" " + exclude));
            }
        }
        this.checkAndCreateOutputDirectory();
        System.out.println();
        System.out.println();
        if (staleDartSources.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to compile - all dart javascripts are up to date");
        } else {
            this.checkDart2Js();
            ExecutorService executor = Executors.newFixedThreadPool(this.threadCount);
            this.getLog().info((CharSequence)("Run " + this.threadCount + " dart2js's in parallel."));
            this.getLog().info((CharSequence)("Compile " + staleDartSources.size() + " dart files"));
            ArrayList<Future<List<String>>> logging = new ArrayList<Future<List<String>>>(staleDartSources.size());
            for (final File dartSourceFile : staleDartSources) {
                this.getLog().info((CharSequence)("Queue " + dartSourceFile.getAbsolutePath() + " to compile."));
                logging.add(executor.submit(new Callable<List<String>>(){

                    @Override
                    public List<String> call() throws Exception {
                        Dart2JsMojo.this.getLog().info((CharSequence)("compile " + dartSourceFile.getAbsolutePath()));
                        ArrayList<String> messages = new ArrayList<String>();
                        try {
                            Commandline cl = Dart2JsMojo.this.createBaseCommandline(messages);
                            Arg outPutFileArg = cl.createArg();
                            Arg dartFileArg = cl.createArg();
                            File dartOutputFile = Dart2JsMojo.this.createOutputFileArgument(messages, outPutFileArg, dartSourceFile);
                            Dart2JsMojo.this.createDartFileArgument(messages, dartFileArg, dartSourceFile);
                            if (Dart2JsMojo.this.getLog().isDebugEnabled()) {
                                messages.add("debug#" + cl.toString());
                            }
                            if (!dartOutputFile.getParentFile().exists()) {
                                if (Dart2JsMojo.this.getLog().isDebugEnabled()) {
                                    messages.add("debug#Create directory " + dartOutputFile.getParentFile().getAbsolutePath());
                                }
                                dartOutputFile.getParentFile().mkdirs();
                            }
                            if (Dart2JsMojo.this.getLog().isDebugEnabled()) {
                                messages.add("debug#" + cl.toString());
                            }
                            StringBuilderWriter writer = new StringBuilderWriter();
                            WriterStreamConsumer output = new WriterStreamConsumer((Writer)writer);
                            int returnValue = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)output, (StreamConsumer)output);
                            writer.flush();
                            writer.close();
                            StringBuilder stringBuilder = writer.getBuilder();
                            messages.add("info#" + stringBuilder.toString());
                            if (Dart2JsMojo.this.getLog().isDebugEnabled()) {
                                messages.add("debug#dart2js return code: " + returnValue);
                            }
                            if (returnValue != 0) {
                                throw new MojoExecutionException(null, "Dart2Js returned error code " + returnValue, stringBuilder.toString());
                            }
                            System.out.println();
                            System.out.println();
                        }
                        catch (CommandLineException e) {
                            messages.add("error#dart2js error: " + e.getMessage());
                            Dart2JsMojo.this.getLog().error((CharSequence)"dart2js error", (Throwable)e);
                        }
                        Dart2JsMojo.this.getLog().info((CharSequence)("done " + dartSourceFile.getAbsolutePath()));
                        return messages;
                    }
                }));
            }
            executor.shutdown();
            try {
                this.logResults(logging);
                this.getLog().info((CharSequence)("Compiling " + staleDartSources.size() + " dart file" + (staleDartSources.size() == 1 ? "" : "s") + " to " + this.outputDirectory.getAbsolutePath()));
            }
            catch (InterruptedException | TimeoutException e) {
                throw new MojoExecutionException("Unable to compile all dart files within " + this.timeout + "ms. Perhaps increase it.", e);
            }
            catch (ExecutionException e) {
                throw new MojoExecutionException("Unable to compile all dart files.", (Exception)e);
            }
        }
        System.out.println();
        System.out.println();
    }

    private void logResults(List<Future<List<String>>> logging) throws InterruptedException, ExecutionException, TimeoutException {
        for (Future<List<String>> future : logging) {
            List<String> messages = this.timeout > 0 ? future.get(this.timeout, TimeUnit.MILLISECONDS) : future.get();
            for (String logMessage : messages) {
                String[] m = logMessage.split("#");
                if (m.length > 1) {
                    String level = m[0];
                    String message = m[1];
                    switch (level) {
                        case "debug": {
                            this.getLog().debug((CharSequence)message);
                            break;
                        }
                        case "info": {
                            this.getLog().info((CharSequence)message);
                            break;
                        }
                        case "warn": {
                            this.getLog().warn((CharSequence)message);
                            break;
                        }
                        case "error": {
                            this.getLog().error((CharSequence)message);
                        }
                    }
                    continue;
                }
                this.getLog().info((CharSequence)logMessage);
            }
        }
    }

    private Commandline createBaseCommandline(List<String> messages) throws MojoExecutionException {
        String dart2jsPath = this.getDart2JsExecutable().getAbsolutePath();
        if (this.getLog().isDebugEnabled()) {
            messages.add("debug#Using dart2js '" + dart2jsPath + "'.");
            messages.add("debug#Source directories: " + this.getCompileSourceRoots().toString().replace(',', '\n'));
            messages.add("debug#Output directory: " + this.getOutputDirectory());
        }
        Commandline cl = new Commandline();
        cl.setExecutable(dart2jsPath);
        if (this.isCheckedMode()) {
            cl.createArg().setValue(ARGUMENT_CHECKED_MODE);
        }
        if (this.isVerbose()) {
            cl.createArg().setValue(ARGUMENT_VERBOSE);
        }
        if (this.isAnalyseAll()) {
            cl.createArg().setValue(ARGUMENT_ANALYSE_ALL);
        }
        if (this.isMinify()) {
            cl.createArg().setValue(ARGUMENT_MINIFY);
        }
        if (this.isSuppressWarnings()) {
            cl.createArg().setValue(ARGUMENT_SUPPRESS_WARNINGS);
        }
        if (this.isSuppressHints()) {
            cl.createArg().setValue(ARGUMENT_SUPPRESS_HINTS);
        }
        if (this.isDiagnosticColors()) {
            cl.createArg().setValue(ARGUMENT_DIAGNOSTIC_COLORS);
        }
        if (this.isPackagePath()) {
            cl.createArg().setValue(ARGUMENT_PACKAGE_PATH + this.packagePath.getAbsolutePath());
        }
        cl.createArg().setValue(ARGUMENT_GLOBAL_JS_NAME + this.globalJsName);
        if (this.getLog().isDebugEnabled()) {
            messages.add("debug#Base dart2js command: " + cl.toString());
        }
        return cl;
    }

    protected void checkDart2Js() {
        this.checkDartSdk();
        if (!this.getDart2JsExecutable().canExecute()) {
            throw new IllegalArgumentException("Dart2js not executable! Configuration error for dartSdk? dartSdk=" + this.getDartSdk().getAbsolutePath());
        }
    }

    protected File getDart2JsExecutable() {
        return new File(this.getDartSdk(), "bin/dart2js" + (OsUtil.isWindows() ? ".bat" : ""));
    }

    private void clearOutputDirectory() throws MojoExecutionException {
        try {
            if (this.outputDirectory.exists()) {
                FileUtils.cleanDirectory((File)this.outputDirectory);
                this.getLog().info((CharSequence)"Cleared all compiled dart-files.");
            }
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)("Unable to clear directory '" + this.outputDirectory.getAbsolutePath() + "'."), (Throwable)e);
            throw new MojoExecutionException("Unable to clear directory '" + this.outputDirectory.getAbsolutePath() + "'.", (Exception)e);
        }
    }

    private void checkAndCreateOutputDirectory() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        } else if (!this.outputDirectory.isDirectory()) {
            throw new MojoExecutionException("Fatal error compiling dart to js. Output directory is not a directory");
        }
    }

    private void createDartFileArgument(List<String> messages, Arg compilerArguments, File dartSourceFile) {
        String dartSourceFileAbsolutePath = dartSourceFile.getAbsolutePath();
        compilerArguments.setValue(dartSourceFileAbsolutePath);
        messages.add("info#dart2js for '" + this.relativePath(dartSourceFile) + "'");
    }

    private File createOutputFileArgument(List<String> messages, Arg outPutFileArg, File dartSourceFile) throws MojoExecutionException {
        String dartSourceFileAbsolutePath = dartSourceFile.getAbsolutePath();
        String dartOutputFileRelativeToBasedir = null;
        for (File compileSourceRoot : this.getCompileSourceRoots()) {
            String compileSourceRootAsString = compileSourceRoot.getAbsolutePath();
            if (!dartSourceFileAbsolutePath.startsWith(compileSourceRootAsString)) continue;
            dartOutputFileRelativeToBasedir = dartSourceFileAbsolutePath.replace(compileSourceRootAsString, "");
            dartOutputFileRelativeToBasedir = dartOutputFileRelativeToBasedir + ".js";
            break;
        }
        if (dartOutputFileRelativeToBasedir == null) {
            messages.add("error#Unable to find compilerSourceRoot for dart file '" + dartSourceFileAbsolutePath + "'");
            messages.add("error#compilerSourceRoots are:");
            for (File compileSourceRoot : this.getCompileSourceRoots()) {
                this.getLog().error((CharSequence)compileSourceRoot.getAbsolutePath());
            }
            System.out.println("");
            System.out.println("");
            throw new MojoExecutionException("There is something wrong. ");
        }
        String dartOutputFile = this.outputDirectory.getAbsolutePath() + dartOutputFileRelativeToBasedir;
        if (this.getLog().isDebugEnabled()) {
            messages.add("debug#dart2js compiles dart-file '" + dartSourceFileAbsolutePath + "' to outputdirectory '" + dartOutputFile + "'");
        }
        outPutFileArg.setValue(ARGUMENT_OUTPUT_FILE + dartOutputFile);
        return new File(dartOutputFile);
    }

    private Set<File> computeStaleSources(Set<File> packageRoots, SourceInclusionScanner scanner) throws MojoExecutionException {
        SuffixMapping mapping = new SuffixMapping("dart", "dart.js");
        scanner.addSourceMapping((SourceMapping)mapping);
        HashSet<File> staleSources = new HashSet<File>();
        for (File packageRoot : packageRoots) {
            try {
                File packageOutputDirectory = this.getPackageOutputDirectory(packageRoot);
                staleSources.addAll(scanner.getIncludedSources(packageRoot, packageOutputDirectory));
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + this.relativePath(packageRoot) + "' for stale files to recompile.", (Exception)((Object)e));
            }
        }
        return staleSources;
    }

    private File getPackageOutputDirectory(File packageRoot) {
        String packageRootOffset = packageRoot.getAbsolutePath();
        for (File compileSourceRoot : this.getCompileSourceRoots()) {
            String compileSourceRootAsString = compileSourceRoot.getAbsolutePath();
            if (!packageRootOffset.startsWith(compileSourceRootAsString)) continue;
            packageRootOffset = packageRootOffset.replace(compileSourceRootAsString + "/", "");
            break;
        }
        return new File(this.getOutputDirectory(), packageRootOffset);
    }

    private SourceInclusionScanner getSourceInclusionScanner() {
        return new StaleSourceScanner((long)this.getStaleMillis(), this.getIncludes(), this.getExcludes());
    }

    public Set<String> getIncludes() {
        if (this.includes.isEmpty()) {
            return ImmutableSet.copyOf(Arrays.asList("web/**/*.dart"));
        }
        return this.includes;
    }

    protected Set<String> getExcludes() {
        if (this.excludes.isEmpty()) {
            return ImmutableSet.copyOf(Arrays.asList("web/**/packages/**"));
        }
        return this.excludes;
    }

    @Override
    public boolean isPubSkipped() {
        return this.skipPub;
    }

    protected boolean isSkipDart2Js() {
        return this.skipDart2Js;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected boolean isCheckedMode() {
        return this.checkedMode;
    }

    protected int getStaleMillis() {
        return this.staleMillis;
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    protected boolean isAnalyseAll() {
        return this.analyseAll;
    }

    protected boolean isMinify() {
        return this.minify;
    }

    protected boolean isSuppressWarnings() {
        return this.suppressWarnings;
    }

    protected boolean isSuppressHints() {
        return this.suppressHints;
    }

    protected boolean isDiagnosticColors() {
        return this.diagnosticColors;
    }

    protected boolean isForce() {
        return this.force;
    }

    protected boolean isPackagePath() {
        return this.packagePath != null;
    }
}

