/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractDartMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", required=true, readonly=true)
    private File basedir;
    @Parameter(defaultValue="src/main/dart", required=true)
    protected File sourceDirectory;
    @Parameter(required=true, defaultValue="${env.DART_SDK}")
    private File dartSdk;
    @Parameter
    private List<File> compileSourceRoots = new ArrayList<File>();

    protected void checkDartSdk() {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Check for DART_SDK.");
        }
        if (this.dartSdk == null) {
            throw new NullPointerException("Dart-sdk required. Configuration error for dartSdk?");
        }
        if (!this.dartSdk.isDirectory()) {
            throw new IllegalArgumentException("Dart-sdk required. Configuration error for dartSdk? dartSdk=" + this.dartSdk.getAbsolutePath());
        }
        this.getLog().info((CharSequence)("Dart-sdk configured to " + this.dartSdk));
        this.getLog().info((CharSequence)("Version: " + this.readDartVersion()));
    }

    protected File getDartSdk() {
        return this.dartSdk;
    }

    public File getBasedir() {
        return this.basedir;
    }

    protected List<File> getCompileSourceRoots() {
        if (this.compileSourceRoots.isEmpty()) {
            return Collections.singletonList(this.sourceDirectory);
        }
        return this.compileSourceRoots;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readDartVersion() {
        File dartVersionFile = new File(this.dartSdk, "version");
        if (!dartVersionFile.isFile()) {
            throw new IllegalArgumentException("Dart version file missing. Configuration error for dartSdk? dartSdk=" + this.dartSdk.getAbsolutePath());
        }
        try (BufferedReader in = new BufferedReader(new FileReader(dartVersionFile));){
            String dartVersion = in.readLine();
            if (StringUtils.isEmpty((String)dartVersion)) {
                throw new NullPointerException("Unable to read dart version. Configuration error for dartSdk?");
            }
            String string = dartVersion;
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read dart version. Configuration error for dartSdk?", e);
        }
    }

    protected Set<File> findDartPackageRoots() throws MojoExecutionException {
        HashSet<File> dartPackageRoots = new HashSet<File>();
        for (File compileSourceRoot : this.getCompileSourceRoots()) {
            if (!compileSourceRoot.exists()) {
                throw new MojoExecutionException("Compiler-source-root '" + compileSourceRoot + "'  does not exist.");
            }
            if (!compileSourceRoot.isDirectory()) {
                throw new MojoExecutionException("Compiler-source-root '" + compileSourceRoot + "'  must be a directory.");
            }
            if (!compileSourceRoot.canRead()) {
                throw new MojoExecutionException("Compiler-source-root '" + compileSourceRoot + "'  must be readable.");
            }
            if (!compileSourceRoot.canWrite()) {
                throw new MojoExecutionException("Compiler-source-root '" + compileSourceRoot + "'  must be writable.");
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Check compile-source-root '" + compileSourceRoot + "' for dart packages."));
            }
            ArrayList pubSpecs = new ArrayList(FileUtils.listFiles((File)compileSourceRoot, (IOFileFilter)new NameFileFilter("pubspec.yaml"), (IOFileFilter)DirectoryFileFilter.DIRECTORY));
            Collections.sort(pubSpecs, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return f1.getAbsolutePath().compareTo(f2.getAbsolutePath());
                }
            });
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"");
                StringBuilder builder = new StringBuilder();
                builder.append("Found pubspec.yaml in ");
                builder.append(compileSourceRoot);
                builder.append(":\n");
                for (File pubSpec : pubSpecs) {
                    builder.append("\t");
                    builder.append(pubSpec.getAbsolutePath().replace(compileSourceRoot + "/", ""));
                    builder.append("\n");
                }
                this.getLog().debug((CharSequence)builder.toString());
                this.getLog().debug((CharSequence)"");
            }
            for (File pubSpec : pubSpecs) {
                File dartPackageRoot = pubSpec.getParentFile();
                if (this.isSubdirectory(dartPackageRoots, dartPackageRoot)) {
                    this.getLog().error((CharSequence)("Recursive package root found " + dartPackageRoot.getAbsolutePath()));
                    throw new MojoExecutionException("Found dart package root which is a subdirectory of another package.");
                }
                dartPackageRoots.add(dartPackageRoot);
            }
        }
        this.logDartPackageRoots(dartPackageRoots);
        return dartPackageRoots;
    }

    private boolean isSubdirectory(Set<File> dartPackageRoots, File dartPackageRootToCheck) {
        String path = dartPackageRootToCheck.getAbsolutePath();
        for (File root : dartPackageRoots) {
            if (!path.startsWith(root.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    protected String relativePath(File absolutePath) {
        return absolutePath.getAbsolutePath().replace(this.getBasedir() + "/", "");
    }

    private void logDartPackageRoots(Set<File> dartPackageRoots) {
        this.getLog().info((CharSequence)"");
        StringBuilder builder = new StringBuilder();
        builder.append("Found package roots:\n");
        for (File dartPackageRoot : dartPackageRoots) {
            builder.append("\t");
            builder.append(this.relativePath(dartPackageRoot));
            builder.append("\n");
        }
        this.getLog().info((CharSequence)builder.toString());
        this.getLog().info((CharSequence)"");
    }
}

