/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamroute.sqlprinter.starter.anno;

import com.github.dreamroute.sqlprinter.starter.anno.SqlprinterProperties;
import com.github.dreamroute.sqlprinter.starter.interceptor.SqlPrinter;
import java.util.Optional;
import java.util.Properties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={SqlprinterProperties.class})
public class SQLPrinterConfig {
    private final SqlprinterProperties sqlprinterProperties;

    public SQLPrinterConfig(SqlprinterProperties sqlprinterProperties) {
        this.sqlprinterProperties = sqlprinterProperties;
    }

    @Bean
    public SqlPrinter sqlPrinter() {
        SqlPrinter printer = new SqlPrinter();
        Properties props = new Properties();
        props.setProperty("sql-show", String.valueOf(this.sqlprinterProperties.isSqlShow()));
        CharSequence[] filter = Optional.ofNullable(this.sqlprinterProperties.getFilter()).orElseGet(() -> new String[0]);
        String result = String.join((CharSequence)",", filter);
        props.setProperty("filter", result);
        printer.setProperties(props);
        return printer;
    }
}

