/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamroute.sqlprinter.starter.interceptor;

import com.github.dreamroute.mybatis.pro.core.typehandler.EnumMarker;
import com.github.dreamroute.sqlprinter.starter.util.PluginUtil;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class SqlPrinter
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(SqlPrinter.class);
    private Properties props = new Properties();

    public Object intercept(Invocation invocation) throws Exception {
        Object result = invocation.proceed();
        this.printSql(invocation);
        return result;
    }

    private void printSql(Invocation invocation) {
        String show = this.props.getProperty("sql-show", "true");
        String filter = this.props.getProperty("filter");
        Map methodNames = Arrays.stream(Optional.ofNullable(filter).orElseGet(String::new).split(",")).collect(Collectors.toMap(Function.identity(), t -> ""));
        String methodName = null;
        DefaultParameterHandler parameterHander = (DefaultParameterHandler)invocation.getTarget();
        try {
            Field mappedStatement = DefaultParameterHandler.class.getDeclaredField("mappedStatement");
            mappedStatement.setAccessible(true);
            MappedStatement ms = (MappedStatement)mappedStatement.get(parameterHander);
            methodName = ms.getId();
        }
        catch (Exception mappedStatement) {
            // empty catch block
        }
        if (Boolean.parseBoolean(show) && !methodNames.containsKey(methodName)) {
            Object target = PluginUtil.processTarget(parameterHander);
            MetaObject handler = SystemMetaObject.forObject((Object)target);
            Object parameterObject = handler.getValue("parameterObject");
            BoundSql boundSql = (BoundSql)handler.getValue("boundSql");
            String originalSql = boundSql.getSql();
            StringBuilder sb = new StringBuilder(originalSql);
            MappedStatement mappedStatement = (MappedStatement)handler.getValue("mappedStatement");
            ErrorContext.instance().activity("setting parameters").object(mappedStatement.getParameterMap().getId());
            List parameterMappings = boundSql.getParameterMappings();
            if (parameterMappings != null) {
                long versionValue = 0L;
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object value;
                    if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                    String propertyName = parameterMapping.getProperty();
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        value = boundSql.getAdditionalParameter(propertyName);
                    } else if (parameterObject == null) {
                        value = null;
                    } else if (mappedStatement.getConfiguration().getTypeHandlerRegistry().hasTypeHandler(parameterObject.getClass())) {
                        value = parameterObject;
                    } else {
                        MetaObject metaObject = mappedStatement.getConfiguration().newMetaObject(parameterObject);
                        value = metaObject.getValue(propertyName);
                    }
                    boolean isEnumMark = value instanceof EnumMarker;
                    if (isEnumMark) {
                        EnumMarker em = (EnumMarker)value;
                        value = em.getValue();
                    }
                    if (Objects.equals(propertyName, "version") && value != null) {
                        versionValue = (Long)value - 1L;
                    }
                    if (!(value instanceof Number) && value != null) {
                        value = "'" + value + "'";
                    }
                    int pos = sb.indexOf("?");
                    sb.replace(pos, pos + 1, String.valueOf(value));
                }
                String result = sb.toString().replace("version = ?", "version = " + versionValue);
                result = result.replace("\n", "").replace("\r", "");
                log.info("Sqlprinter\u63d2\u4ef6\u6253\u5370SQL: {}", (Object)result);
            }
        }
    }

    public Object plugin(Object target) {
        if (target instanceof ParameterHandler) {
            target = Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        this.props = properties;
    }
}

