/*
 * Decompiled with CFR 0.152.
 */
package com.github.doyaaaaaken.kotlincsv.client;

import com.github.doyaaaaaken.kotlincsv.client.CsvFileWriter$WhenMappings;
import com.github.doyaaaaaken.kotlincsv.client.CsvWriterStateHandler;
import com.github.doyaaaaaken.kotlincsv.client.ICsvFileWriter;
import com.github.doyaaaaaken.kotlincsv.dsl.context.CsvWriterContext;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018H\u0002J%\u0010\u001a\u001a\u00020\u00122\u0016\u0010\u001b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00190\u001c\"\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001a\u001a\u00020\u00122\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018H\u0016J\u001e\u0010\u001e\u001a\u00020\u00122\u0014\u0010\u001f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00180\u0018H\u0016J\u001e\u0010\u001e\u001a\u00020\u00122\u0014\u0010\u001f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00180 H\u0016J\b\u0010!\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/github/doyaaaaaken/kotlincsv/client/CsvFileWriter;", "Lcom/github/doyaaaaaken/kotlincsv/client/ICsvFileWriter;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "ctx", "Lcom/github/doyaaaaaken/kotlincsv/dsl/context/CsvWriterContext;", "writer", "Ljava/io/PrintWriter;", "(Lcom/github/doyaaaaaken/kotlincsv/dsl/context/CsvWriterContext;Ljava/io/PrintWriter;)V", "quoteNeededChars", "", "", "stateHandler", "Lcom/github/doyaaaaaken/kotlincsv/client/CsvWriterStateHandler;", "attachQuote", "", "field", "close", "", "flush", "willWriteEndTerminator", "willWritePreTerminator", "writeNext", "row", "", "", "writeRow", "entry", "", "([Ljava/lang/Object;)V", "writeRows", "rows", "Lkotlin/sequences/Sequence;", "writeTerminator", "kotlin-csv"})
public final class CsvFileWriter
implements ICsvFileWriter,
Closeable,
Flushable {
    private final CsvWriterStateHandler stateHandler;
    private final Set<Character> quoteNeededChars;
    private final CsvWriterContext ctx;
    private final PrintWriter writer;

    @Override
    public void writeRow(@NotNull List<? extends Object> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        this.willWritePreTerminator();
        this.writeNext(row);
        this.willWriteEndTerminator();
        if (this.writer.checkError()) {
            throw (Throwable)new IOException("Failed to write");
        }
    }

    @Override
    public void writeRow(Object ... entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.writeRow(ArraysKt.toList((Object[])entry));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeRows(@NotNull List<? extends List<? extends Object>> rows) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        this.willWritePreTerminator();
        Iterable $this$forEachIndexed$iv = rows;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void list;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list2 = (List)item$iv;
            int index = n;
            boolean bl2 = false;
            this.writeNext((List<? extends Object>)list);
            if (index >= rows.size() - 1) continue;
            this.writeTerminator();
        }
        this.willWriteEndTerminator();
        if (this.writer.checkError()) {
            throw (Throwable)new IOException("Failed to write");
        }
    }

    @Override
    public void writeRows(@NotNull Sequence<? extends List<? extends Object>> rows) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        this.willWritePreTerminator();
        Iterator itr = rows.iterator();
        while (itr.hasNext()) {
            this.writeNext((List)itr.next());
            if (!itr.hasNext()) continue;
            this.writeTerminator();
        }
        this.willWriteEndTerminator();
        if (this.writer.checkError()) {
            throw (Throwable)new IOException("Failed to write");
        }
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    /*
     * WARNING - void declaration
     */
    private final void writeNext(List<? extends Object> row) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = row;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void field;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = field == null ? this.ctx.getNullCode() : this.attachQuote(field.toString());
            collection.add(string);
        }
        String rowStr = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)String.valueOf(this.ctx.getDelimiter()), null, null, (int)0, null, null, (int)62, null);
        this.writer.print(rowStr);
    }

    private final void willWriteEndTerminator() {
        if (this.ctx.getOutputLastLineTerminator()) {
            this.writeTerminator();
            this.stateHandler.setStateOfWroteLineEndTerminator();
        } else {
            this.stateHandler.setStateOfNotWroteLineEndTerminator();
        }
    }

    private final void willWritePreTerminator() {
        if (this.stateHandler.hasWroteFirstLine() && !this.stateHandler.hasWroteLineEndTerminator()) {
            this.writeTerminator();
        }
    }

    private final void writeTerminator() {
        this.writer.print(this.ctx.getLineTerminator());
        this.stateHandler.setStateOfWroteLineEndTerminator();
    }

    private final String attachQuote(String field) {
        int n;
        boolean bl;
        block0 : switch (CsvFileWriter$WhenMappings.$EnumSwitchMapping$0[this.ctx.getQuote().getMode().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                int element$iv;
                CharSequence $this$any$iv = field;
                boolean $i$f$any = false;
                CharSequence charSequence = $this$any$iv;
                for (n = 0; n < charSequence.length(); ++n) {
                    int ch = element$iv = (int)charSequence.charAt(n);
                    boolean bl2 = false;
                    if (!this.quoteNeededChars.contains(Character.valueOf((char)ch))) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 3: {
                int element$iv;
                boolean foundDot = false;
                CharSequence $this$any$iv = field;
                boolean $i$f$any = false;
                CharSequence charSequence = $this$any$iv;
                for (element$iv = 0; element$iv < charSequence.length(); ++element$iv) {
                    boolean bl3;
                    char element$iv2;
                    char ch = element$iv2 = charSequence.charAt(element$iv);
                    boolean bl4 = false;
                    if (ch == '.') {
                        if (foundDot) {
                            bl3 = true;
                        } else {
                            foundDot = true;
                            bl3 = false;
                        }
                    } else {
                        bl3 = Intrinsics.compare((int)ch, (int)48) < 0 || Intrinsics.compare((int)ch, (int)57) > 0;
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean shouldQuote = bl;
        boolean bl5 = false;
        boolean bl6 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl7 = false;
        n = 0;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl8 = false;
        if (shouldQuote) {
            $this$buildString.append(this.ctx.getQuote().getChar());
        }
        CharSequence $this$forEach$iv = field;
        boolean $i$f$forEach = false;
        CharSequence charSequence = $this$forEach$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char ch = element$iv = charSequence.charAt(i);
            boolean bl9 = false;
            if (ch == this.ctx.getQuote().getChar()) {
                $this$buildString.append(this.ctx.getQuote().getChar());
            }
            $this$buildString.append(ch);
        }
        if (shouldQuote) {
            $this$buildString.append(this.ctx.getQuote().getChar());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public CsvFileWriter(@NotNull CsvWriterContext ctx, @NotNull PrintWriter writer) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.ctx = ctx;
        this.writer = writer;
        this.stateHandler = new CsvWriterStateHandler();
        this.quoteNeededChars = SetsKt.setOf((Object[])new Character[]{Character.valueOf('\r'), Character.valueOf('\n'), Character.valueOf(this.ctx.getQuote().getChar()), Character.valueOf(this.ctx.getDelimiter())});
    }
}

