/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import org.json.Kim;
import org.json.zip.JSONzip;
import org.json.zip.Keep;
import org.json.zip.PostMortem;

class TrieKeep
extends Keep {
    private int[] froms;
    private int[] thrus;
    private Node root;
    private Kim[] kims;

    public TrieKeep(int bits2) {
        super(bits2);
        this.froms = new int[this.capacity];
        this.thrus = new int[this.capacity];
        this.kims = new Kim[this.capacity];
        this.root = new Node();
    }

    public Kim kim(int integer) {
        Kim kim = this.kims[integer];
        int from2 = this.froms[integer];
        int thru = this.thrus[integer];
        if (from2 != 0 || thru != kim.length) {
            kim = new Kim(kim, from2, thru);
            this.froms[integer] = 0;
            this.thrus[integer] = kim.length;
            this.kims[integer] = kim;
        }
        return kim;
    }

    public int length(int integer) {
        return this.thrus[integer] - this.froms[integer];
    }

    public int match(Kim kim, int from2, int thru) {
        Node node = this.root;
        int best = -1;
        for (int at = from2; at < thru && (node = node.get(kim.get(at))) != null; ++at) {
            if (node.integer != -1) {
                best = node.integer;
            }
            ++from2;
        }
        return best;
    }

    public boolean postMortem(PostMortem pm) {
        boolean result2 = true;
        TrieKeep that = (TrieKeep)pm;
        if (this.length != that.length) {
            JSONzip.log("\nLength " + this.length + " <> " + that.length);
            return false;
        }
        if (this.capacity != that.capacity) {
            JSONzip.log("\nCapacity " + this.capacity + " <> " + that.capacity);
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            Kim thatkim;
            Kim thiskim = this.kim(i);
            if (thiskim.equals(thatkim = that.kim(i))) continue;
            JSONzip.log("\n[" + i + "] " + thiskim + " <> " + thatkim);
            result2 = false;
        }
        return result2 && this.root.postMortem(that.root);
    }

    public void registerMany(Kim kim) {
        int length = kim.length;
        int limit = this.capacity - this.length;
        if (limit > 40) {
            limit = 40;
        }
        int until2 = length - 2;
        for (int from2 = 0; from2 < until2; ++from2) {
            int len = length - from2;
            if (len > 10) {
                len = 10;
            }
            len += from2;
            Node node = this.root;
            for (int at = from2; at < len; ++at) {
                Node next2 = node.vet(kim.get(at));
                if (next2.integer == -1 && at - from2 >= 2) {
                    next2.integer = this.length;
                    this.uses[this.length] = 1L;
                    this.kims[this.length] = kim;
                    this.froms[this.length] = from2;
                    this.thrus[this.length] = at + 1;
                    ++this.length;
                    if (--limit <= 0) {
                        return;
                    }
                }
                node = next2;
            }
        }
    }

    public void registerOne(Kim kim) {
        int integer = this.registerOne(kim, 0, kim.length);
        if (integer != -1) {
            this.kims[integer] = kim;
        }
    }

    public int registerOne(Kim kim, int from2, int thru) {
        if (this.length < this.capacity) {
            Node node = this.root;
            for (int at = from2; at < thru; ++at) {
                node = node.vet(kim.get(at));
            }
            if (node.integer == -1) {
                int integer = this.length++;
                node.integer = integer;
                this.uses[integer] = 1L;
                this.kims[integer] = kim;
                this.froms[integer] = from2;
                this.thrus[integer] = thru;
                return integer;
            }
        }
        return -1;
    }

    public void reserve() {
        if (this.capacity - this.length < 40) {
            int to2 = 0;
            this.root = new Node();
            for (int from2 = 0; from2 < this.capacity; ++from2) {
                if (this.uses[from2] <= 1L) continue;
                Kim kim = this.kims[from2];
                int thru = this.thrus[from2];
                Node node = this.root;
                for (int at = this.froms[from2]; at < thru; ++at) {
                    Node next2;
                    node = next2 = node.vet(kim.get(at));
                }
                node.integer = to2;
                this.uses[to2] = TrieKeep.age(this.uses[from2]);
                this.froms[to2] = this.froms[from2];
                this.thrus[to2] = thru;
                this.kims[to2] = kim;
                ++to2;
            }
            if (this.capacity - to2 < 40) {
                this.power = 0;
                this.root = new Node();
                to2 = 0;
            }
            this.length = to2;
            while (to2 < this.capacity) {
                this.uses[to2] = 0L;
                this.kims[to2] = null;
                this.froms[to2] = 0;
                this.thrus[to2] = 0;
                ++to2;
            }
        }
    }

    public Object value(int integer) {
        return this.kim(integer);
    }

    class Node
    implements PostMortem {
        private int integer = -1;
        private Node[] next = null;

        public Node get(int cell) {
            return this.next == null ? null : this.next[cell];
        }

        public Node get(byte cell) {
            return this.get(cell & 0xFF);
        }

        public boolean postMortem(PostMortem pm) {
            Node that = (Node)pm;
            if (that == null) {
                JSONzip.log("\nMisalign");
                return false;
            }
            if (this.integer != that.integer) {
                JSONzip.log("\nInteger " + this.integer + " <> " + that.integer);
                return false;
            }
            if (this.next == null) {
                if (that.next == null) {
                    return true;
                }
                JSONzip.log("\nNext is null " + this.integer);
                return false;
            }
            for (int i = 0; i < 256; ++i) {
                Node node = this.next[i];
                if (node != null) {
                    if (node.postMortem(that.next[i])) continue;
                    return false;
                }
                if (that.next[i] == null) continue;
                JSONzip.log("\nMisalign " + i);
                return false;
            }
            return true;
        }

        public void set(int cell, Node node) {
            if (this.next == null) {
                this.next = new Node[256];
            }
            this.next[cell] = node;
        }

        public void set(byte cell, Node node) {
            this.set(cell & 0xFF, node);
        }

        public Node vet(int cell) {
            Node node = this.get(cell);
            if (node == null) {
                node = new Node();
                this.set(cell, node);
            }
            return node;
        }

        public Node vet(byte cell) {
            return this.vet(cell & 0xFF);
        }
    }
}

