/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.Kim;
import org.json.zip.BitWriter;
import org.json.zip.Huff;
import org.json.zip.JSONzip;
import org.json.zip.Keep;

public class Compressor
extends JSONzip {
    final BitWriter bitwriter;

    public Compressor(BitWriter bitwriter) {
        this.bitwriter = bitwriter;
    }

    private static int bcd(char digit2) {
        if (digit2 >= '0' && digit2 <= '9') {
            return digit2 - 48;
        }
        switch (digit2) {
            case '.': {
                return 10;
            }
            case '-': {
                return 11;
            }
            case '+': {
                return 12;
            }
        }
        return 13;
    }

    public void flush() throws JSONException {
        this.pad(8);
    }

    private void one() throws JSONException {
        this.write(1, 1);
    }

    public void pad(int factor) throws JSONException {
        try {
            this.bitwriter.pad(factor);
        }
        catch (Throwable e) {
            throw new JSONException(e);
        }
    }

    private void write(int integer, int width) throws JSONException {
        try {
            this.bitwriter.write(integer, width);
        }
        catch (Throwable e) {
            throw new JSONException(e);
        }
    }

    private void write(int integer, Huff huff) throws JSONException {
        huff.write(integer, this.bitwriter);
    }

    private void write(Kim kim, Huff huff) throws JSONException {
        this.write(kim, 0, kim.length, huff);
    }

    private void write(Kim kim, int from2, int thru, Huff huff) throws JSONException {
        for (int at = from2; at < thru; ++at) {
            this.write(kim.get(at), huff);
        }
    }

    private void writeAndTick(int integer, Keep keep) throws JSONException {
        int width = keep.bitsize();
        keep.tick(integer);
        this.write(integer, width);
    }

    private void writeArray(JSONArray jsonarray) throws JSONException {
        boolean stringy = false;
        int length = jsonarray.length();
        if (length == 0) {
            this.write(1, 3);
        } else {
            Object value2 = jsonarray.get(0);
            if (value2 == null) {
                value2 = JSONObject.NULL;
            }
            if (value2 instanceof String) {
                stringy = true;
                this.write(6, 3);
                this.writeString((String)value2);
            } else {
                this.write(7, 3);
                this.writeValue(value2);
            }
            for (int i = 1; i < length; ++i) {
                value2 = jsonarray.get(i);
                if (value2 == null) {
                    value2 = JSONObject.NULL;
                }
                if (value2 instanceof String != stringy) {
                    this.zero();
                }
                this.one();
                if (value2 instanceof String) {
                    this.writeString((String)value2);
                    continue;
                }
                this.writeValue(value2);
            }
            this.zero();
            this.zero();
        }
    }

    private void writeJSON(Object value2) throws JSONException {
        if (JSONObject.NULL.equals(value2)) {
            this.write(4, 3);
        } else if (Boolean.FALSE.equals(value2)) {
            this.write(3, 3);
        } else if (Boolean.TRUE.equals(value2)) {
            this.write(2, 3);
        } else {
            if (value2 instanceof Map) {
                value2 = new JSONObject((Map)value2);
            } else if (value2 instanceof Collection) {
                value2 = new JSONArray((Collection)value2);
            } else if (value2.getClass().isArray()) {
                value2 = new JSONArray(value2);
            }
            if (value2 instanceof JSONObject) {
                this.writeObject((JSONObject)value2);
            } else if (value2 instanceof JSONArray) {
                this.writeArray((JSONArray)value2);
            } else {
                throw new JSONException("Unrecognized object");
            }
        }
    }

    private void writeName(String name) throws JSONException {
        Kim kim = new Kim(name);
        int integer = this.namekeep.find(kim);
        if (integer != -1) {
            this.one();
            this.writeAndTick(integer, this.namekeep);
        } else {
            this.zero();
            this.write(kim, this.namehuff);
            this.write(256, this.namehuff);
            this.namekeep.register(kim);
        }
    }

    private void writeObject(JSONObject jsonobject) throws JSONException {
        boolean first = true;
        Iterator keys = jsonobject.keys();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!(key instanceof String)) continue;
            if (first) {
                first = false;
                this.write(5, 3);
            } else {
                this.one();
            }
            this.writeName((String)key);
            Object value2 = jsonobject.get((String)key);
            if (value2 instanceof String) {
                this.zero();
                this.writeString((String)value2);
                continue;
            }
            this.one();
            this.writeValue(value2);
        }
        if (first) {
            this.write(0, 3);
        } else {
            this.zero();
        }
    }

    private void writeString(String string2) throws JSONException {
        if (string2.length() == 0) {
            this.zero();
            this.zero();
            this.write(256, this.substringhuff);
            this.zero();
        } else {
            Kim kim = new Kim(string2);
            int integer = this.stringkeep.find(kim);
            if (integer != -1) {
                this.one();
                this.writeAndTick(integer, this.stringkeep);
            } else {
                this.writeSubstring(kim);
                this.stringkeep.register(kim);
            }
        }
    }

    private void writeSubstring(Kim kim) throws JSONException {
        this.substringkeep.reserve();
        this.zero();
        int from2 = 0;
        int thru = kim.length;
        int until2 = thru - 3;
        int previousFrom = -1;
        int previousThru = 0;
        while (true) {
            int at;
            int integer = -1;
            for (at = from2; at <= until2 && (integer = this.substringkeep.match(kim, at, thru)) == -1; ++at) {
            }
            if (integer == -1) break;
            if (from2 != at) {
                this.zero();
                this.write(kim, from2, at, this.substringhuff);
                this.write(256, this.substringhuff);
                if (previousFrom != -1) {
                    this.substringkeep.registerOne(kim, previousFrom, previousThru);
                    previousFrom = -1;
                }
            }
            this.one();
            this.writeAndTick(integer, this.substringkeep);
            from2 = at + this.substringkeep.length(integer);
            if (previousFrom != -1) {
                this.substringkeep.registerOne(kim, previousFrom, previousThru);
                previousFrom = -1;
            }
            previousFrom = at;
            previousThru = from2 + 1;
        }
        this.zero();
        if (from2 < thru) {
            this.write(kim, from2, thru, this.substringhuff);
            if (previousFrom != -1) {
                this.substringkeep.registerOne(kim, previousFrom, previousThru);
            }
        }
        this.write(256, this.substringhuff);
        this.zero();
        this.substringkeep.registerMany(kim);
    }

    private void writeValue(Object value2) throws JSONException {
        if (value2 instanceof Number) {
            long longer;
            String string2 = JSONObject.numberToString((Number)value2);
            int integer = this.values.find(string2);
            if (integer != -1) {
                this.write(2, 2);
                this.writeAndTick(integer, this.values);
                return;
            }
            if ((value2 instanceof Integer || value2 instanceof Long) && (longer = ((Number)value2).longValue()) >= 0L && longer < 16384L) {
                this.write(0, 2);
                if (longer < 16L) {
                    this.zero();
                    this.write((int)longer, 4);
                    return;
                }
                this.one();
                if (longer < 128L) {
                    this.zero();
                    this.write((int)longer, 7);
                    return;
                }
                this.one();
                this.write((int)longer, 14);
                return;
            }
            this.write(1, 2);
            for (int i = 0; i < string2.length(); ++i) {
                this.write(Compressor.bcd(string2.charAt(i)), 4);
            }
            this.write(endOfNumber, 4);
            this.values.register(string2);
        } else {
            this.write(3, 2);
            this.writeJSON(value2);
        }
    }

    private void zero() throws JSONException {
        this.write(0, 1);
    }

    public void zip(JSONObject jsonobject) throws JSONException {
        this.begin();
        this.writeJSON(jsonobject);
    }

    public void zip(JSONArray jsonarray) throws JSONException {
        this.begin();
        this.writeJSON(jsonarray);
    }
}

