/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XMLTokener;

public class XML {
    public static final Character AMP = new Character('&');
    public static final Character APOS = new Character('\'');
    public static final Character BANG = new Character('!');
    public static final Character EQ = new Character('=');
    public static final Character GT = new Character('>');
    public static final Character LT = new Character('<');
    public static final Character QUEST = new Character('?');
    public static final Character QUOT = new Character('\"');
    public static final Character SLASH = new Character('/');

    public static String escape(String string2) {
        StringBuffer sb = new StringBuffer();
        int length = string2.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static void noSpace(String string2) throws JSONException {
        int length = string2.length();
        if (length == 0) {
            throw new JSONException("Empty string.");
        }
        for (int i = 0; i < length; ++i) {
            if (!Character.isWhitespace(string2.charAt(i))) continue;
            throw new JSONException("'" + string2 + "' contains a space character.");
        }
    }

    private static boolean parse(XMLTokener x, JSONObject context, String name) throws JSONException {
        String string2;
        JSONObject jsonobject = null;
        Object token2 = x.nextToken();
        if (token2 == BANG) {
            char c = x.next();
            if (c == '-') {
                if (x.next() == '-') {
                    x.skipPast("-->");
                    return false;
                }
                x.back();
            } else if (c == '[') {
                token2 = x.nextToken();
                if ("CDATA".equals(token2) && x.next() == '[') {
                    String string3 = x.nextCDATA();
                    if (string3.length() > 0) {
                        context.accumulate("content", string3);
                    }
                    return false;
                }
                throw x.syntaxError("Expected 'CDATA['");
            }
            int i = 1;
            do {
                if ((token2 = x.nextMeta()) == null) {
                    throw x.syntaxError("Missing '>' after '<!'.");
                }
                if (token2 == LT) {
                    ++i;
                    continue;
                }
                if (token2 != GT) continue;
                --i;
            } while (i > 0);
            return false;
        }
        if (token2 == QUEST) {
            x.skipPast("?>");
            return false;
        }
        if (token2 == SLASH) {
            token2 = x.nextToken();
            if (name == null) {
                throw x.syntaxError("Mismatched close tag " + token2);
            }
            if (!token2.equals(name)) {
                throw x.syntaxError("Mismatched " + name + " and " + token2);
            }
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (token2 instanceof Character) {
            throw x.syntaxError("Misshaped tag");
        }
        String tagName = (String)token2;
        token2 = null;
        jsonobject = new JSONObject();
        while (true) {
            if (token2 == null) {
                token2 = x.nextToken();
            }
            if (!(token2 instanceof String)) break;
            string2 = (String)token2;
            token2 = x.nextToken();
            if (token2 == EQ) {
                token2 = x.nextToken();
                if (!(token2 instanceof String)) {
                    throw x.syntaxError("Missing value");
                }
                jsonobject.accumulate(string2, XML.stringToValue((String)token2));
                token2 = null;
                continue;
            }
            jsonobject.accumulate(string2, "");
        }
        if (token2 == SLASH) {
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped tag");
            }
            if (jsonobject.length() > 0) {
                context.accumulate(tagName, jsonobject);
            } else {
                context.accumulate(tagName, "");
            }
            return false;
        }
        if (token2 == GT) {
            while (true) {
                if ((token2 = x.nextContent()) == null) {
                    if (tagName != null) {
                        throw x.syntaxError("Unclosed tag " + tagName);
                    }
                    return false;
                }
                if (token2 instanceof String) {
                    string2 = (String)token2;
                    if (string2.length() <= 0) continue;
                    jsonobject.accumulate("content", XML.stringToValue(string2));
                    continue;
                }
                if (token2 == LT && XML.parse(x, jsonobject, tagName)) break;
            }
            if (jsonobject.length() == 0) {
                context.accumulate(tagName, "");
            } else if (jsonobject.length() == 1 && jsonobject.opt("content") != null) {
                context.accumulate(tagName, jsonobject.opt("content"));
            } else {
                context.accumulate(tagName, jsonobject);
            }
            return false;
        }
        throw x.syntaxError("Misshaped tag");
    }

    public static Object stringToValue(String string2) {
        if ("true".equalsIgnoreCase(string2)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return Boolean.FALSE;
        }
        if ("null".equalsIgnoreCase(string2)) {
            return JSONObject.NULL;
        }
        try {
            Long value2;
            char initial = string2.charAt(0);
            if ((initial == '-' || initial >= '0' && initial <= '9') && (value2 = new Long(string2)).toString().equals(string2)) {
                return value2;
            }
        }
        catch (Exception ignore) {
            try {
                Double value3 = new Double(string2);
                if (value3.toString().equals(string2)) {
                    return value3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    public static JSONObject toJSONObject(String string2) throws JSONException {
        JSONObject jo = new JSONObject();
        XMLTokener x = new XMLTokener(string2);
        while (x.more() && x.skipPast("<")) {
            XML.parse(x, jo, null);
        }
        return jo;
    }

    public static String toString(Object object) throws JSONException {
        return XML.toString(object, null);
    }

    public static String toString(Object object, String tagName) throws JSONException {
        String string2;
        StringBuffer sb = new StringBuffer();
        if (object instanceof JSONObject) {
            if (tagName != null) {
                sb.append('<');
                sb.append(tagName);
                sb.append('>');
            }
            JSONObject jo = (JSONObject)object;
            Iterator keys = jo.keys();
            while (keys.hasNext()) {
                int i;
                int length;
                JSONArray ja;
                String key = keys.next().toString();
                Object value2 = jo.opt(key);
                if (value2 == null) {
                    value2 = "";
                }
                String string3 = value2 instanceof String ? (String)value2 : null;
                if ("content".equals(key)) {
                    if (value2 instanceof JSONArray) {
                        ja = (JSONArray)value2;
                        length = ja.length();
                        for (i = 0; i < length; ++i) {
                            if (i > 0) {
                                sb.append('\n');
                            }
                            sb.append(XML.escape(ja.get(i).toString()));
                        }
                        continue;
                    }
                    sb.append(XML.escape(value2.toString()));
                    continue;
                }
                if (value2 instanceof JSONArray) {
                    ja = (JSONArray)value2;
                    length = ja.length();
                    for (i = 0; i < length; ++i) {
                        value2 = ja.get(i);
                        if (value2 instanceof JSONArray) {
                            sb.append('<');
                            sb.append(key);
                            sb.append('>');
                            sb.append(XML.toString(value2));
                            sb.append("</");
                            sb.append(key);
                            sb.append('>');
                            continue;
                        }
                        sb.append(XML.toString(value2, key));
                    }
                    continue;
                }
                if ("".equals(value2)) {
                    sb.append('<');
                    sb.append(key);
                    sb.append("/>");
                    continue;
                }
                sb.append(XML.toString(value2, key));
            }
            if (tagName != null) {
                sb.append("</");
                sb.append(tagName);
                sb.append('>');
            }
            return sb.toString();
        }
        if (object.getClass().isArray()) {
            object = new JSONArray(object);
        }
        if (object instanceof JSONArray) {
            JSONArray ja = (JSONArray)object;
            int length = ja.length();
            for (int i = 0; i < length; ++i) {
                sb.append(XML.toString(ja.opt(i), tagName == null ? "array" : tagName));
            }
            return sb.toString();
        }
        String string4 = string2 = object == null ? "null" : XML.escape(object.toString());
        return tagName == null ? "\"" + string2 + "\"" : (string2.length() == 0 ? "<" + tagName + "/>" : "<" + tagName + ">" + string2 + "</" + tagName + ">");
    }
}

