/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.websocketx;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.base64.Base64;
import org.jboss.netty.util.CharsetUtil;

final class WebSocketUtil {
    static ChannelBuffer md5(ChannelBuffer buffer) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (buffer.hasArray()) {
                int offset = buffer.arrayOffset() + buffer.readerIndex();
                int length = buffer.readableBytes();
                md.update(buffer.array(), offset, length);
            } else {
                md.update(buffer.toByteBuffer());
            }
            return ChannelBuffers.wrappedBuffer(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("MD5 not supported on this platform");
        }
    }

    static ChannelBuffer sha1(ChannelBuffer buffer) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            if (buffer.hasArray()) {
                int offset = buffer.arrayOffset() + buffer.readerIndex();
                int length = buffer.readableBytes();
                md.update(buffer.array(), offset, length);
            } else {
                md.update(buffer.toByteBuffer());
            }
            return ChannelBuffers.wrappedBuffer(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("SHA-1 not supported on this platform");
        }
    }

    static String base64(ChannelBuffer buffer) {
        return Base64.encode(buffer).toString(CharsetUtil.UTF_8);
    }

    static byte[] randomBytes(int size2) {
        byte[] bytes = new byte[size2];
        for (int i = 0; i < size2; ++i) {
            bytes[i] = (byte)WebSocketUtil.randomNumber(0, 255);
        }
        return bytes;
    }

    static int randomNumber(int min2, int max2) {
        return (int)(Math.random() * (double)max2 + (double)min2);
    }

    private WebSocketUtil() {
    }
}

