/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class CharacterCodec
implements Codec<Character> {
    @Override
    public void encode(BsonWriter writer, Character value2, EncoderContext encoderContext) {
        Assertions.notNull("value", value2);
        writer.writeString(value2.toString());
    }

    @Override
    public Character decode(BsonReader reader, DecoderContext decoderContext) {
        String string2 = reader.readString();
        if (string2.length() != 1) {
            throw new BsonInvalidOperationException(String.format("Attempting to decode the string '%s' to a character, but its length is not equal to one", string2));
        }
        return Character.valueOf(string2.charAt(0));
    }

    @Override
    public Class<Character> getEncoderClass() {
        return Character.class;
    }
}

