/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.BsonType;
import org.bson.BsonValue;

public final class BsonTimestamp
extends BsonValue
implements Comparable<BsonTimestamp> {
    private final int seconds;
    private final int inc;

    public BsonTimestamp() {
        this.seconds = 0;
        this.inc = 0;
    }

    public BsonTimestamp(int seconds, int inc) {
        this.seconds = seconds;
        this.inc = inc;
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.TIMESTAMP;
    }

    public int getTime() {
        return this.seconds;
    }

    public int getInc() {
        return this.inc;
    }

    public String toString() {
        return "Timestamp{seconds=" + this.seconds + ", inc=" + this.inc + '}';
    }

    @Override
    public int compareTo(BsonTimestamp ts) {
        if (this.getTime() != ts.getTime()) {
            return this.getTime() - ts.getTime();
        }
        return this.getInc() - ts.getInc();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BsonTimestamp timestamp2 = (BsonTimestamp)o;
        if (this.seconds != timestamp2.seconds) {
            return false;
        }
        return this.inc == timestamp2.inc;
    }

    public int hashCode() {
        int result2 = this.seconds;
        result2 = 31 * result2 + this.inc;
        return result2;
    }
}

