/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import com.mongodb.DBRef;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.bson.AbstractBsonWriter;
import org.bson.BSON;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonBinaryWriter;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.OutputBuffer;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;

public class BasicBSONEncoder
implements BSONEncoder {
    private BsonBinaryWriter bsonWriter;
    private OutputBuffer outputBuffer;

    @Override
    public byte[] encode(BSONObject document) {
        BasicOutputBuffer outputBuffer = new BasicOutputBuffer();
        this.set(outputBuffer);
        this.putObject(document);
        this.done();
        return outputBuffer.toByteArray();
    }

    @Override
    public void done() {
        this.bsonWriter.close();
        this.bsonWriter = null;
    }

    @Override
    public void set(OutputBuffer buffer) {
        if (this.bsonWriter != null) {
            throw new IllegalStateException("Performing another operation at this moment");
        }
        this.outputBuffer = buffer;
        this.bsonWriter = new BsonBinaryWriter(buffer);
    }

    protected OutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    protected BsonBinaryWriter getBsonWriter() {
        return this.bsonWriter;
    }

    @Override
    public int putObject(BSONObject document) {
        int startPosition = this.getOutputBuffer().getPosition();
        this.bsonWriter.writeStartDocument();
        if (this.isTopLevelDocument() && document.containsField("_id")) {
            this._putObjectField("_id", document.get("_id"));
        }
        for (String key : document.keySet()) {
            if (this.isTopLevelDocument() && key.equals("_id")) continue;
            this._putObjectField(key, document.get(key));
        }
        this.bsonWriter.writeEndDocument();
        return this.getOutputBuffer().getPosition() - startPosition;
    }

    private boolean isTopLevelDocument() {
        return this.bsonWriter.getContext().getParentContext() == null;
    }

    protected void putName(String name) {
        if (this.bsonWriter.getState() == AbstractBsonWriter.State.NAME) {
            this.bsonWriter.writeName(name);
        }
    }

    protected void _putObjectField(String name, Object initialValue) {
        Object value2;
        if ("_transientFields".equals(name)) {
            return;
        }
        if (name.contains("\u0000")) {
            throw new IllegalArgumentException("Document field names can't have a NULL character. (Bad Key: '" + name + "')");
        }
        if ("$where".equals(name) && initialValue instanceof String) {
            this.putCode(name, new Code((String)initialValue));
        }
        if ((value2 = BSON.applyEncodingHooks(initialValue)) == null) {
            this.putNull(name);
        } else if (value2 instanceof Date) {
            this.putDate(name, (Date)value2);
        } else if (value2 instanceof Number) {
            this.putNumber(name, (Number)value2);
        } else if (value2 instanceof Character) {
            this.putString(name, value2.toString());
        } else if (value2 instanceof String) {
            this.putString(name, value2.toString());
        } else if (value2 instanceof ObjectId) {
            this.putObjectId(name, (ObjectId)value2);
        } else if (value2 instanceof Boolean) {
            this.putBoolean(name, (Boolean)value2);
        } else if (value2 instanceof Pattern) {
            this.putPattern(name, (Pattern)value2);
        } else if (value2 instanceof Iterable) {
            this.putIterable(name, (Iterable)value2);
        } else if (value2 instanceof BSONObject) {
            this.putObject(name, (BSONObject)value2);
        } else if (value2 instanceof Map) {
            this.putMap(name, (Map)value2);
        } else if (value2 instanceof byte[]) {
            this.putBinary(name, (byte[])value2);
        } else if (value2 instanceof Binary) {
            this.putBinary(name, (Binary)value2);
        } else if (value2 instanceof UUID) {
            this.putUUID(name, (UUID)value2);
        } else if (value2.getClass().isArray()) {
            this.putArray(name, value2);
        } else if (value2 instanceof Symbol) {
            this.putSymbol(name, (Symbol)value2);
        } else if (value2 instanceof BSONTimestamp) {
            this.putTimestamp(name, (BSONTimestamp)value2);
        } else if (value2 instanceof CodeWScope) {
            this.putCodeWScope(name, (CodeWScope)value2);
        } else if (value2 instanceof Code) {
            this.putCode(name, (Code)value2);
        } else if (value2 instanceof DBRef) {
            BasicBSONObject temp = new BasicBSONObject();
            DBRef dbRef = (DBRef)value2;
            temp.put("$ref", dbRef.getCollectionName());
            temp.put("$id", dbRef.getId());
            if (dbRef.getDatabaseName() != null) {
                temp.put("$db", dbRef.getDatabaseName());
            }
            this.putObject(name, temp);
        } else if (value2 instanceof MinKey) {
            this.putMinKey(name);
        } else if (value2 instanceof MaxKey) {
            this.putMaxKey(name);
        } else if (!this.putSpecial(name, value2)) {
            throw new IllegalArgumentException("Can't serialize " + value2.getClass());
        }
    }

    protected void putNull(String name) {
        this.putName(name);
        this.bsonWriter.writeNull();
    }

    protected void putUndefined(String name) {
        this.putName(name);
        this.bsonWriter.writeUndefined();
    }

    protected void putTimestamp(String name, BSONTimestamp timestamp2) {
        this.putName(name);
        this.bsonWriter.writeTimestamp(new BsonTimestamp(timestamp2.getTime(), timestamp2.getInc()));
    }

    protected void putCode(String name, Code code) {
        this.putName(name);
        this.bsonWriter.writeJavaScript(code.getCode());
    }

    protected void putCodeWScope(String name, CodeWScope codeWScope) {
        this.putName(name);
        this.bsonWriter.writeJavaScriptWithScope(codeWScope.getCode());
        this.putObject(codeWScope.getScope());
    }

    protected void putBoolean(String name, Boolean value2) {
        this.putName(name);
        this.bsonWriter.writeBoolean(value2);
    }

    protected void putDate(String name, Date date) {
        this.putName(name);
        this.bsonWriter.writeDateTime(date.getTime());
    }

    protected void putNumber(String name, Number number2) {
        this.putName(name);
        if (number2 instanceof Integer || number2 instanceof Short || number2 instanceof Byte || number2 instanceof AtomicInteger) {
            this.bsonWriter.writeInt32(number2.intValue());
        } else if (number2 instanceof Long || number2 instanceof AtomicLong) {
            this.bsonWriter.writeInt64(number2.longValue());
        } else if (number2 instanceof Float || number2 instanceof Double) {
            this.bsonWriter.writeDouble(number2.doubleValue());
        } else {
            throw new IllegalArgumentException("Can't serialize " + number2.getClass());
        }
    }

    protected void putBinary(String name, byte[] bytes) {
        this.putName(name);
        this.bsonWriter.writeBinaryData(new BsonBinary(bytes));
    }

    protected void putBinary(String name, Binary binary) {
        this.putName(name);
        this.bsonWriter.writeBinaryData(new BsonBinary(binary.getType(), binary.getData()));
    }

    protected void putUUID(String name, UUID uuid) {
        this.putName(name);
        byte[] bytes = new byte[16];
        BasicBSONEncoder.writeLongToArrayLittleEndian(bytes, 0, uuid.getMostSignificantBits());
        BasicBSONEncoder.writeLongToArrayLittleEndian(bytes, 8, uuid.getLeastSignificantBits());
        this.bsonWriter.writeBinaryData(new BsonBinary(BsonBinarySubType.UUID_LEGACY, bytes));
    }

    protected void putSymbol(String name, Symbol symbol) {
        this.putName(name);
        this.bsonWriter.writeSymbol(symbol.getSymbol());
    }

    protected void putString(String name, String value2) {
        this.putName(name);
        this.bsonWriter.writeString(value2);
    }

    protected void putPattern(String name, Pattern value2) {
        this.putName(name);
        this.bsonWriter.writeRegularExpression(new BsonRegularExpression(value2.pattern(), BSON.regexFlags(value2.flags())));
    }

    protected void putObjectId(String name, ObjectId objectId) {
        this.putName(name);
        this.bsonWriter.writeObjectId(objectId);
    }

    protected void putArray(String name, Object object) {
        this.putName(name);
        this.bsonWriter.writeStartArray();
        if (object instanceof int[]) {
            for (int i : (int[])object) {
                this.bsonWriter.writeInt32(i);
            }
        } else if (object instanceof long[]) {
            for (long i : (long[])object) {
                this.bsonWriter.writeInt64(i);
            }
        } else if (object instanceof float[]) {
            for (float i : (float[])object) {
                this.bsonWriter.writeDouble(i);
            }
        } else if (object instanceof short[]) {
            for (short i : (short[])object) {
                this.bsonWriter.writeInt32(i);
            }
        } else if (object instanceof byte[]) {
            for (byte i : (byte[])object) {
                this.bsonWriter.writeInt32(i);
            }
        } else if (object instanceof double[]) {
            for (double i : (double[])object) {
                this.bsonWriter.writeDouble(i);
            }
        } else if (object instanceof boolean[]) {
            for (boolean i : (boolean[])object) {
                this.bsonWriter.writeBoolean(i);
            }
        } else if (object instanceof String[]) {
            for (String i : (String[])object) {
                this.bsonWriter.writeString(i);
            }
        } else {
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                this._putObjectField(String.valueOf(i), Array.get(object, i));
            }
        }
        this.bsonWriter.writeEndArray();
    }

    protected void putIterable(String name, Iterable iterable) {
        this.putName(name);
        this.bsonWriter.writeStartArray();
        int i = 0;
        for (Object o : iterable) {
            this._putObjectField(String.valueOf(i), o);
        }
        this.bsonWriter.writeEndArray();
    }

    protected void putMap(String name, Map map2) {
        this.putName(name);
        this.bsonWriter.writeStartDocument();
        for (Map.Entry entry2 : map2.entrySet()) {
            this._putObjectField((String)entry2.getKey(), entry2.getValue());
        }
        this.bsonWriter.writeEndDocument();
    }

    protected int putObject(String name, BSONObject document) {
        this.putName(name);
        return this.putObject(document);
    }

    protected boolean putSpecial(String name, Object special) {
        return false;
    }

    protected void putMinKey(String name) {
        this.putName(name);
        this.bsonWriter.writeMinKey();
    }

    protected void putMaxKey(String name) {
        this.putName(name);
        this.bsonWriter.writeMaxKey();
    }

    private static void writeLongToArrayLittleEndian(byte[] bytes, int offset, long x) {
        bytes[offset] = (byte)(0xFFL & x);
        bytes[offset + 1] = (byte)(0xFFL & x >> 8);
        bytes[offset + 2] = (byte)(0xFFL & x >> 16);
        bytes[offset + 3] = (byte)(0xFFL & x >> 24);
        bytes[offset + 4] = (byte)(0xFFL & x >> 32);
        bytes[offset + 5] = (byte)(0xFFL & x >> 40);
        bytes[offset + 6] = (byte)(0xFFL & x >> 48);
        bytes[offset + 7] = (byte)(0xFFL & x >> 56);
    }
}

