/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.AbstractBsonWriter;
import org.bson.BSONCallback;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonContextType;
import org.bson.BsonDbPointer;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonWriterSettings;
import org.bson.io.Bits;
import org.bson.types.ObjectId;

class BSONCallbackAdapter
extends AbstractBsonWriter {
    private BSONCallback bsonCallback;

    protected BSONCallbackAdapter(BsonWriterSettings settings, BSONCallback bsonCallback) {
        super(settings);
        this.bsonCallback = bsonCallback;
    }

    @Override
    public void flush() {
    }

    @Override
    public void doWriteStartDocument() {
        BsonContextType contextType;
        BsonContextType bsonContextType = contextType = this.getState() == AbstractBsonWriter.State.SCOPE_DOCUMENT ? BsonContextType.SCOPE_DOCUMENT : BsonContextType.DOCUMENT;
        if (this.getContext() == null || contextType == BsonContextType.SCOPE_DOCUMENT) {
            this.bsonCallback.objectStart();
        } else {
            this.bsonCallback.objectStart(this.getName());
        }
        this.setContext(new Context(this.getContext(), contextType));
    }

    @Override
    protected void doWriteEndDocument() {
        BsonContextType contextType = this.getContext().getContextType();
        this.setContext(this.getContext().getParentContext());
        this.bsonCallback.objectDone();
        if (contextType == BsonContextType.SCOPE_DOCUMENT) {
            Object scope = this.bsonCallback.get();
            this.bsonCallback = this.getContext().callback;
            this.bsonCallback.gotCodeWScope(this.getContext().name, this.getContext().code, scope);
        }
    }

    @Override
    public void doWriteStartArray() {
        this.bsonCallback.arrayStart(this.getName());
        this.setContext(new Context(this.getContext(), BsonContextType.ARRAY));
    }

    @Override
    protected void doWriteEndArray() {
        this.setContext(this.getContext().getParentContext());
        this.bsonCallback.arrayDone();
    }

    @Override
    protected void doWriteBinaryData(BsonBinary value2) {
        if (value2.getType() == BsonBinarySubType.UUID_LEGACY.getValue()) {
            this.bsonCallback.gotUUID(this.getName(), Bits.readLong(value2.getData(), 0), Bits.readLong(value2.getData(), 8));
        } else {
            this.bsonCallback.gotBinary(this.getName(), value2.getType(), value2.getData());
        }
    }

    @Override
    public void doWriteBoolean(boolean value2) {
        this.bsonCallback.gotBoolean(this.getName(), value2);
        this.setState(this.getNextState());
    }

    @Override
    protected void doWriteDateTime(long value2) {
        this.bsonCallback.gotDate(this.getName(), value2);
    }

    @Override
    protected void doWriteDBPointer(BsonDbPointer value2) {
        this.bsonCallback.gotDBRef(this.getName(), value2.getNamespace(), value2.getId());
    }

    @Override
    protected void doWriteDouble(double value2) {
        this.bsonCallback.gotDouble(this.getName(), value2);
    }

    @Override
    protected void doWriteInt32(int value2) {
        this.bsonCallback.gotInt(this.getName(), value2);
    }

    @Override
    protected void doWriteInt64(long value2) {
        this.bsonCallback.gotLong(this.getName(), value2);
    }

    @Override
    protected void doWriteJavaScript(String value2) {
        this.bsonCallback.gotCode(this.getName(), value2);
    }

    @Override
    protected void doWriteJavaScriptWithScope(String value2) {
        this.getContext().callback = this.bsonCallback;
        this.getContext().code = value2;
        this.getContext().name = this.getName();
        this.bsonCallback = this.bsonCallback.createBSONCallback();
    }

    @Override
    protected void doWriteMaxKey() {
        this.bsonCallback.gotMaxKey(this.getName());
    }

    @Override
    protected void doWriteMinKey() {
        this.bsonCallback.gotMinKey(this.getName());
    }

    @Override
    public void doWriteNull() {
        this.bsonCallback.gotNull(this.getName());
    }

    @Override
    public void doWriteObjectId(ObjectId value2) {
        this.bsonCallback.gotObjectId(this.getName(), value2);
    }

    @Override
    public void doWriteRegularExpression(BsonRegularExpression value2) {
        this.bsonCallback.gotRegex(this.getName(), value2.getPattern(), value2.getOptions());
    }

    @Override
    public void doWriteString(String value2) {
        this.bsonCallback.gotString(this.getName(), value2);
    }

    @Override
    public void doWriteSymbol(String value2) {
        this.bsonCallback.gotSymbol(this.getName(), value2);
    }

    @Override
    public void doWriteTimestamp(BsonTimestamp value2) {
        this.bsonCallback.gotTimestamp(this.getName(), value2.getTime(), value2.getInc());
    }

    @Override
    public void doWriteUndefined() {
        this.bsonCallback.gotUndefined(this.getName());
    }

    @Override
    protected Context getContext() {
        return (Context)super.getContext();
    }

    @Override
    protected String getName() {
        if (this.getContext().getContextType() == BsonContextType.ARRAY) {
            return Integer.toString(this.getContext().index++);
        }
        return super.getName();
    }

    public class Context
    extends AbstractBsonWriter.Context {
        private int index;
        private BSONCallback callback;
        private String code;
        private String name;

        public Context(Context parentContext, BsonContextType contextType) {
            super(parentContext, contextType);
        }

        @Override
        public Context getParentContext() {
            return (Context)super.getParentContext();
        }
    }
}

