/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.server.ZooKeeperThread;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.LeaderElectionBean;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class AuthFastLeaderElection
implements Election {
    private static final Logger LOG = LoggerFactory.getLogger(AuthFastLeaderElection.class);
    static int sequencer = 0;
    static int maxTag = 0;
    static int finalizeWait = 100;
    static int challengeCounter = 0;
    private boolean authEnabled = false;
    LinkedBlockingQueue<ToSend> sendqueue;
    LinkedBlockingQueue<Notification> recvqueue;
    QuorumPeer self;
    int port;
    volatile long logicalclock;
    DatagramSocket mySocket;
    long proposedLeader;
    long proposedZxid;

    public AuthFastLeaderElection(QuorumPeer self, boolean auth) {
        this.authEnabled = auth;
        this.starter(self);
    }

    public AuthFastLeaderElection(QuorumPeer self) {
        this.starter(self);
    }

    private void starter(QuorumPeer self) {
        this.self = self;
        this.port = self.getVotingView().get((Object)Long.valueOf((long)self.getId())).electionAddr.getPort();
        this.proposedLeader = -1L;
        this.proposedZxid = -1L;
        try {
            this.mySocket = new DatagramSocket(this.port);
        }
        catch (SocketException e1) {
            e1.printStackTrace();
            throw new RuntimeException();
        }
        this.sendqueue = new LinkedBlockingQueue(2 * self.getVotingView().size());
        this.recvqueue = new LinkedBlockingQueue(2 * self.getVotingView().size());
        new Messenger(self.getVotingView().size() * 2, this.mySocket);
    }

    private void leaveInstance() {
        ++this.logicalclock;
    }

    private void sendNotifications() {
        for (QuorumPeer.QuorumServer server : this.self.getView().values()) {
            ToSend notmsg = new ToSend(ToSend.mType.notification, sequencer++, this.proposedLeader, this.proposedZxid, this.logicalclock, QuorumPeer.ServerState.LOOKING, this.self.getView().get((Object)Long.valueOf((long)server.id)).electionAddr);
            this.sendqueue.offer(notmsg);
        }
    }

    private boolean totalOrderPredicate(long id, long zxid) {
        return zxid > this.proposedZxid || zxid == this.proposedZxid && id > this.proposedLeader;
    }

    private boolean termPredicate(HashMap<InetSocketAddress, Vote> votes, long l, long zxid) {
        Collection<Vote> votesCast = votes.values();
        int count2 = 0;
        for (Vote v : votesCast) {
            if (v.getId() != l || v.getZxid() != zxid) continue;
            ++count2;
        }
        return count2 > this.self.getVotingView().size() / 2;
    }

    @Override
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Vote lookForLeader() throws InterruptedException {
        block40: {
            block34: {
                block39: {
                    block33: {
                        block38: {
                            block32: {
                                block37: {
                                    block31: {
                                        block36: {
                                            block30: {
                                                try {
                                                    this.self.jmxLeaderElectionBean = new LeaderElectionBean();
                                                    MBeanRegistry.getInstance().register(this.self.jmxLeaderElectionBean, this.self.jmxLocalPeerBean);
                                                }
                                                catch (Exception e) {
                                                    AuthFastLeaderElection.LOG.warn("Failed to register with JMX", e);
                                                    this.self.jmxLeaderElectionBean = null;
                                                }
                                                try {
                                                    recvset = new HashMap<InetSocketAddress, Vote>();
                                                    outofelection = new HashMap<InetSocketAddress, Vote>();
                                                    ++this.logicalclock;
                                                    this.proposedLeader = this.self.getId();
                                                    this.proposedZxid = this.self.getLastLoggedZxid();
                                                    AuthFastLeaderElection.LOG.info("Election tally");
                                                    this.sendNotifications();
                                                    while (this.self.getPeerState() == QuorumPeer.ServerState.LOOKING) {
                                                        n = this.recvqueue.poll(2 * AuthFastLeaderElection.finalizeWait, TimeUnit.MILLISECONDS);
                                                        if (n == null) {
                                                            if (outofelection.isEmpty() && recvset.size() <= 1) continue;
                                                            this.sendNotifications();
                                                            continue;
                                                        }
                                                        switch (1.$SwitchMap$org$apache$zookeeper$server$quorum$QuorumPeer$ServerState[n.state.ordinal()]) {
                                                            case 1: {
                                                                if (n.epoch > this.logicalclock) {
                                                                    this.logicalclock = n.epoch;
                                                                    recvset.clear();
                                                                    if (this.totalOrderPredicate(n.leader, n.zxid)) {
                                                                        this.proposedLeader = n.leader;
                                                                        this.proposedZxid = n.zxid;
                                                                    }
                                                                    this.sendNotifications();
                                                                } else {
                                                                    if (n.epoch < this.logicalclock) break;
                                                                    if (this.totalOrderPredicate(n.leader, n.zxid)) {
                                                                        this.proposedLeader = n.leader;
                                                                        this.proposedZxid = n.zxid;
                                                                        this.sendNotifications();
                                                                    }
                                                                }
                                                                recvset.put(n.addr, new Vote(n.leader, n.zxid));
                                                                if (this.self.getVotingView().size() == recvset.size()) {
                                                                    this.self.setPeerState(this.proposedLeader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                                                                    this.leaveInstance();
                                                                    var4_5 = new Vote(this.proposedLeader, this.proposedZxid);
                                                                    var6_9 = null;
                                                                    break block30;
                                                                }
                                                                if (!this.termPredicate(recvset, this.proposedLeader, this.proposedZxid)) break;
                                                                AuthFastLeaderElection.LOG.info("Passed predicate");
                                                                Thread.sleep(AuthFastLeaderElection.finalizeWait);
                                                                while (!this.recvqueue.isEmpty() && !this.totalOrderPredicate(this.recvqueue.peek().leader, this.recvqueue.peek().zxid)) {
                                                                    this.recvqueue.poll();
                                                                }
                                                                if (!this.recvqueue.isEmpty()) break;
                                                                this.self.setPeerState(this.proposedLeader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                                                                this.leaveInstance();
                                                                var4_6 = new Vote(this.proposedLeader, this.proposedZxid);
                                                                break block31;
                                                            }
                                                            case 2: {
                                                                outofelection.put(n.addr, new Vote(n.leader, n.zxid));
                                                                if (!this.termPredicate(outofelection, n.leader, n.zxid)) break;
                                                                this.self.setPeerState(n.leader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                                                                this.leaveInstance();
                                                                var4_7 = new Vote(n.leader, n.zxid);
                                                                break block32;
                                                            }
                                                            case 3: {
                                                                outofelection.put(n.addr, new Vote(n.leader, n.zxid));
                                                                if (!this.termPredicate(outofelection, n.leader, n.zxid)) break;
                                                                this.self.setPeerState(n.leader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                                                                this.leaveInstance();
                                                                var4_8 = new Vote(n.leader, n.zxid);
                                                                break block33;
                                                            }
                                                        }
                                                    }
                                                    var3_4 = null;
                                                    break block34;
                                                }
                                                catch (Throwable var5_21) {
                                                    var6_14 = null;
                                                    try {
                                                        if (this.self.jmxLeaderElectionBean != null) {
                                                            MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        AuthFastLeaderElection.LOG.warn("Failed to unregister with JMX", e);
                                                    }
                                                    this.self.jmxLeaderElectionBean = null;
                                                    throw var5_21;
                                                }
                                            }
                                            ** try [egrp 2[TRYBLOCK] [7 : 800->826)] { 
lbl95:
                                            // 1 sources

                                            if (this.self.jmxLeaderElectionBean != null) {
                                                MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
                                            }
                                            break block36;
lbl98:
                                            // 1 sources

                                            catch (Exception e) {
                                                AuthFastLeaderElection.LOG.warn("Failed to unregister with JMX", e);
                                            }
                                        }
                                        this.self.jmxLeaderElectionBean = null;
                                        return var4_5;
                                    }
                                    var6_10 = null;
                                    ** try [egrp 2[TRYBLOCK] [7 : 800->826)] { 
lbl106:
                                    // 1 sources

                                    if (this.self.jmxLeaderElectionBean != null) {
                                        MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
                                    }
                                    break block37;
lbl109:
                                    // 1 sources

                                    catch (Exception e) {
                                        AuthFastLeaderElection.LOG.warn("Failed to unregister with JMX", e);
                                    }
                                }
                                this.self.jmxLeaderElectionBean = null;
                                return var4_6;
                            }
                            var6_11 = null;
                            ** try [egrp 2[TRYBLOCK] [7 : 800->826)] { 
lbl117:
                            // 1 sources

                            if (this.self.jmxLeaderElectionBean != null) {
                                MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
                            }
                            break block38;
lbl120:
                            // 1 sources

                            catch (Exception e) {
                                AuthFastLeaderElection.LOG.warn("Failed to unregister with JMX", e);
                            }
                        }
                        this.self.jmxLeaderElectionBean = null;
                        return var4_7;
                    }
                    var6_12 = null;
                    ** try [egrp 2[TRYBLOCK] [7 : 800->826)] { 
lbl128:
                    // 1 sources

                    if (this.self.jmxLeaderElectionBean != null) {
                        MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
                    }
                    break block39;
lbl131:
                    // 1 sources

                    catch (Exception e) {
                        AuthFastLeaderElection.LOG.warn("Failed to unregister with JMX", e);
                    }
                }
                this.self.jmxLeaderElectionBean = null;
                return var4_8;
            }
            var6_13 = null;
            ** try [egrp 2[TRYBLOCK] [7 : 800->826)] { 
lbl139:
            // 1 sources

            if (this.self.jmxLeaderElectionBean != null) {
                MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
            }
            break block40;
lbl142:
            // 1 sources

            catch (Exception e) {
                AuthFastLeaderElection.LOG.warn("Failed to unregister with JMX", e);
            }
        }
        this.self.jmxLeaderElectionBean = null;
        return var3_4;
    }

    private class Messenger {
        final DatagramSocket mySocket;
        long lastProposedLeader;
        long lastProposedZxid;
        long lastEpoch;
        final Set<Long> ackset;
        final ConcurrentHashMap<Long, Long> challengeMap;
        final ConcurrentHashMap<Long, Semaphore> challengeMutex;
        final ConcurrentHashMap<Long, Semaphore> ackMutex;
        final ConcurrentHashMap<InetSocketAddress, ConcurrentHashMap<Long, Long>> addrChallengeMap;

        public boolean queueEmpty() {
            return AuthFastLeaderElection.this.sendqueue.isEmpty() || this.ackset.isEmpty() || AuthFastLeaderElection.this.recvqueue.isEmpty();
        }

        Messenger(int threads, DatagramSocket s2) {
            this.mySocket = s2;
            this.ackset = Collections.newSetFromMap(new ConcurrentHashMap());
            this.challengeMap = new ConcurrentHashMap();
            this.challengeMutex = new ConcurrentHashMap();
            this.ackMutex = new ConcurrentHashMap();
            this.addrChallengeMap = new ConcurrentHashMap();
            this.lastProposedLeader = 0L;
            this.lastProposedZxid = 0L;
            this.lastEpoch = 0L;
            for (int i = 0; i < threads; ++i) {
                ZooKeeperThread t = new ZooKeeperThread(new WorkerSender(3), "WorkerSender Thread: " + (i + 1));
                t.setDaemon(true);
                t.start();
            }
            for (QuorumPeer.QuorumServer server : AuthFastLeaderElection.this.self.getVotingView().values()) {
                InetSocketAddress saddr = new InetSocketAddress(server.addr.getAddress(), AuthFastLeaderElection.this.port);
                this.addrChallengeMap.put(saddr, new ConcurrentHashMap());
            }
            ZooKeeperThread t = new ZooKeeperThread(new WorkerReceiver(s2, this), "WorkerReceiver-" + s2.getRemoteSocketAddress());
            t.start();
        }

        class WorkerSender
        implements Runnable {
            Random rand;
            int maxAttempts;
            int ackWait = finalizeWait;

            WorkerSender(int attempts) {
                this.maxAttempts = attempts;
                this.rand = new Random(Thread.currentThread().getId() + System.currentTimeMillis());
            }

            long genChallenge() {
                byte[] buf = new byte[8];
                buf[0] = (byte)((challengeCounter & 0xFF000000) >>> 24);
                buf[1] = (byte)((challengeCounter & 0xFF0000) >>> 16);
                buf[2] = (byte)((challengeCounter & 0xFF00) >>> 8);
                buf[3] = (byte)(challengeCounter & 0xFF);
                ++challengeCounter;
                int secret = this.rand.nextInt(Integer.MAX_VALUE);
                buf[4] = (byte)((secret & 0xFF000000) >>> 24);
                buf[5] = (byte)((secret & 0xFF0000) >>> 16);
                buf[6] = (byte)((secret & 0xFF00) >>> 8);
                buf[7] = (byte)(secret & 0xFF);
                return ((long)(buf[0] & 0xFF) << 56) + ((long)(buf[1] & 0xFF) << 48) + ((long)(buf[2] & 0xFF) << 40) + ((long)(buf[3] & 0xFF) << 32) + ((long)(buf[4] & 0xFF) << 24) + ((long)(buf[5] & 0xFF) << 16) + ((long)(buf[6] & 0xFF) << 8) + (long)(buf[7] & 0xFF);
            }

            public void run() {
                try {
                    while (true) {
                        ToSend m = AuthFastLeaderElection.this.sendqueue.take();
                        this.process(m);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void process(ToSend m) {
                int attempts = 0;
                byte[] requestBytes = new byte[48];
                DatagramPacket requestPacket = new DatagramPacket(requestBytes, requestBytes.length);
                ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
                switch (m.type) {
                    case 0: {
                        requestBuffer.clear();
                        requestBuffer.putInt(ToSend.mType.crequest.ordinal());
                        requestBuffer.putLong(m.tag);
                        requestBuffer.putInt(m.state.ordinal());
                        byte[] zeroes = new byte[32];
                        requestBuffer.put(zeroes);
                        requestPacket.setLength(48);
                        try {
                            requestPacket.setSocketAddress(m.addr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + m.addr, e);
                        }
                        try {
                            if (Messenger.this.challengeMap.get(m.tag) != null) break;
                            Messenger.this.mySocket.send(requestPacket);
                        }
                        catch (IOException e) {
                            LOG.warn("Exception while sending challenge: ", e);
                        }
                        break;
                    }
                    case 1: {
                        ConcurrentHashMap<Long, Long> tmpMap = Messenger.this.addrChallengeMap.get(m.addr);
                        if (tmpMap != null) {
                            Long tmpLong = tmpMap.get(m.tag);
                            long newChallenge = tmpLong != null ? tmpLong.longValue() : this.genChallenge();
                            tmpMap.put(m.tag, newChallenge);
                            requestBuffer.clear();
                            requestBuffer.putInt(ToSend.mType.challenge.ordinal());
                            requestBuffer.putLong(m.tag);
                            requestBuffer.putInt(m.state.ordinal());
                            requestBuffer.putLong(newChallenge);
                            byte[] zeroes = new byte[24];
                            requestBuffer.put(zeroes);
                            requestPacket.setLength(48);
                            try {
                                requestPacket.setSocketAddress(m.addr);
                            }
                            catch (IllegalArgumentException e) {
                                throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + m.addr, e);
                            }
                            try {
                                Messenger.this.mySocket.send(requestPacket);
                            }
                            catch (IOException e) {
                                LOG.warn("Exception while sending challenge: ", e);
                            }
                            break;
                        }
                        LOG.error("Address is not in the configuration: " + m.addr);
                        break;
                    }
                    case 2: {
                        requestBuffer.clear();
                        requestBuffer.putInt(m.type);
                        requestBuffer.putLong(m.tag);
                        requestBuffer.putInt(m.state.ordinal());
                        requestBuffer.putLong(m.leader);
                        requestBuffer.putLong(m.zxid);
                        requestBuffer.putLong(m.epoch);
                        byte[] zeroes = new byte[8];
                        requestBuffer.put(zeroes);
                        requestPacket.setLength(48);
                        try {
                            requestPacket.setSocketAddress(m.addr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + m.addr, e);
                        }
                        boolean myChallenge = false;
                        boolean myAck = false;
                        while (attempts < this.maxAttempts) {
                            try {
                                if (!myChallenge && AuthFastLeaderElection.this.authEnabled) {
                                    ToSend crequest = new ToSend(ToSend.mType.crequest, m.tag, m.leader, m.zxid, m.epoch, QuorumPeer.ServerState.LOOKING, m.addr);
                                    AuthFastLeaderElection.this.sendqueue.offer(crequest);
                                    try {
                                        double timeout = (double)this.ackWait * Math.pow(2.0, attempts);
                                        Semaphore s2 = new Semaphore(0);
                                        Messenger messenger = Messenger.this;
                                        synchronized (messenger) {
                                            Messenger.this.challengeMutex.put(m.tag, s2);
                                            s2.tryAcquire((long)timeout, TimeUnit.MILLISECONDS);
                                            myChallenge = Messenger.this.challengeMap.containsKey(m.tag);
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        LOG.warn("Challenge request exception: ", e);
                                    }
                                }
                                if (AuthFastLeaderElection.this.authEnabled && !myChallenge) {
                                    ++attempts;
                                    continue;
                                }
                                if (AuthFastLeaderElection.this.authEnabled) {
                                    requestBuffer.position(40);
                                    Long tmpLong = Messenger.this.challengeMap.get(m.tag);
                                    if (tmpLong != null) {
                                        requestBuffer.putLong(tmpLong);
                                    } else {
                                        LOG.warn("No challenge with tag: " + m.tag);
                                    }
                                }
                                Messenger.this.mySocket.send(requestPacket);
                                try {
                                    Semaphore s3 = new Semaphore(0);
                                    double timeout = (double)this.ackWait * Math.pow(10.0, attempts);
                                    Messenger.this.ackMutex.put(m.tag, s3);
                                    s3.tryAcquire((int)timeout, TimeUnit.MILLISECONDS);
                                }
                                catch (InterruptedException e) {
                                    LOG.warn("Ack exception: ", e);
                                }
                                if (Messenger.this.ackset.remove(m.tag)) {
                                    myAck = true;
                                }
                            }
                            catch (IOException e) {
                                LOG.warn("Sending exception: ", e);
                            }
                            if (myAck) {
                                Messenger.this.challengeMap.remove(m.tag);
                                return;
                            }
                            ++attempts;
                        }
                        if (m.epoch != AuthFastLeaderElection.this.logicalclock) break;
                        Messenger.this.challengeMap.remove(m.tag);
                        AuthFastLeaderElection.this.sendqueue.offer(m);
                        break;
                    }
                    case 3: {
                        requestBuffer.clear();
                        requestBuffer.putInt(m.type);
                        requestBuffer.putLong(m.tag);
                        requestBuffer.putInt(m.state.ordinal());
                        requestBuffer.putLong(m.leader);
                        requestBuffer.putLong(m.zxid);
                        requestBuffer.putLong(m.epoch);
                        requestPacket.setLength(48);
                        try {
                            requestPacket.setSocketAddress(m.addr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + m.addr, e);
                        }
                        try {
                            Messenger.this.mySocket.send(requestPacket);
                            break;
                        }
                        catch (IOException e) {
                            LOG.warn("Exception while sending ack: ", e);
                        }
                    }
                }
            }
        }

        class WorkerReceiver
        implements Runnable {
            DatagramSocket mySocket;
            Messenger myMsg;

            WorkerReceiver(DatagramSocket s2, Messenger msg) {
                this.mySocket = s2;
                this.myMsg = msg;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean saveChallenge(long tag, long challenge) {
                Semaphore s2 = Messenger.this.challengeMutex.get(tag);
                if (s2 != null) {
                    Messenger messenger = Messenger.this;
                    synchronized (messenger) {
                        Messenger.this.challengeMap.put(tag, challenge);
                        Messenger.this.challengeMutex.remove(tag);
                    }
                    s2.release();
                } else {
                    LOG.error("No challenge mutex object");
                }
                return true;
            }

            public void run() {
                byte[] responseBytes = new byte[48];
                ByteBuffer responseBuffer = ByteBuffer.wrap(responseBytes);
                DatagramPacket responsePacket = new DatagramPacket(responseBytes, responseBytes.length);
                block13: while (true) {
                    try {
                        responseBuffer.clear();
                        this.mySocket.receive(responsePacket);
                    }
                    catch (IOException e) {
                        LOG.warn("Ignoring exception receiving", e);
                    }
                    if (responsePacket.getLength() != responseBytes.length) {
                        LOG.warn("Got a short response: " + responsePacket.getLength() + " " + responsePacket.toString());
                        continue;
                    }
                    responseBuffer.clear();
                    int type = responseBuffer.getInt();
                    if (type > 3 || type < 0) {
                        LOG.warn("Got bad Msg type: " + type);
                        continue;
                    }
                    long tag = responseBuffer.getLong();
                    QuorumPeer.ServerState ackstate = QuorumPeer.ServerState.LOOKING;
                    switch (responseBuffer.getInt()) {
                        case 0: {
                            ackstate = QuorumPeer.ServerState.LOOKING;
                            break;
                        }
                        case 1: {
                            ackstate = QuorumPeer.ServerState.LEADING;
                            break;
                        }
                        case 2: {
                            ackstate = QuorumPeer.ServerState.FOLLOWING;
                        }
                    }
                    Vote current = AuthFastLeaderElection.this.self.getCurrentVote();
                    switch (type) {
                        case 0: {
                            ToSend c = new ToSend(ToSend.mType.challenge, tag, current.getId(), current.getZxid(), AuthFastLeaderElection.this.logicalclock, AuthFastLeaderElection.this.self.getPeerState(), (InetSocketAddress)responsePacket.getSocketAddress());
                            AuthFastLeaderElection.this.sendqueue.offer(c);
                            break;
                        }
                        case 1: {
                            long challenge = responseBuffer.getLong();
                            this.saveChallenge(tag, challenge);
                            break;
                        }
                        case 2: {
                            Notification n = new Notification();
                            n.leader = responseBuffer.getLong();
                            n.zxid = responseBuffer.getLong();
                            n.epoch = responseBuffer.getLong();
                            n.state = ackstate;
                            n.addr = (InetSocketAddress)responsePacket.getSocketAddress();
                            if (this.myMsg.lastEpoch <= n.epoch && (n.zxid > this.myMsg.lastProposedZxid || n.zxid == this.myMsg.lastProposedZxid && n.leader > this.myMsg.lastProposedLeader)) {
                                this.myMsg.lastProposedZxid = n.zxid;
                                this.myMsg.lastProposedLeader = n.leader;
                                this.myMsg.lastEpoch = n.epoch;
                            }
                            InetSocketAddress addr = (InetSocketAddress)responsePacket.getSocketAddress();
                            if (AuthFastLeaderElection.this.authEnabled) {
                                ConcurrentHashMap<Long, Long> tmpMap = Messenger.this.addrChallengeMap.get(addr);
                                if (tmpMap == null) continue block13;
                                if (tmpMap.get(tag) != null) {
                                    long recChallenge = responseBuffer.getLong();
                                    if (tmpMap.get(tag) == recChallenge) {
                                        AuthFastLeaderElection.this.recvqueue.offer(n);
                                        ToSend a = new ToSend(ToSend.mType.ack, tag, current.getId(), current.getZxid(), AuthFastLeaderElection.this.logicalclock, AuthFastLeaderElection.this.self.getPeerState(), addr);
                                        AuthFastLeaderElection.this.sendqueue.offer(a);
                                        break;
                                    }
                                    LOG.warn("Incorrect challenge: " + recChallenge + ", " + Messenger.this.addrChallengeMap.toString());
                                    break;
                                }
                                LOG.warn("No challenge for host: " + addr + " " + tag);
                                break;
                            }
                            AuthFastLeaderElection.this.recvqueue.offer(n);
                            ToSend a = new ToSend(ToSend.mType.ack, tag, current.getId(), current.getZxid(), AuthFastLeaderElection.this.logicalclock, AuthFastLeaderElection.this.self.getPeerState(), (InetSocketAddress)responsePacket.getSocketAddress());
                            AuthFastLeaderElection.this.sendqueue.offer(a);
                            break;
                        }
                        case 3: {
                            Semaphore s2 = Messenger.this.ackMutex.get(tag);
                            if (s2 != null) {
                                s2.release();
                            } else {
                                LOG.error("Empty ack semaphore");
                            }
                            Messenger.this.ackset.add(tag);
                            if (AuthFastLeaderElection.this.authEnabled) {
                                ConcurrentHashMap<Long, Long> tmpMap = Messenger.this.addrChallengeMap.get(responsePacket.getSocketAddress());
                                if (tmpMap != null) {
                                    tmpMap.remove(tag);
                                } else {
                                    LOG.warn("No such address in the ensemble configuration " + responsePacket.getSocketAddress());
                                }
                            }
                            if (ackstate == QuorumPeer.ServerState.LOOKING) continue block13;
                            Notification outofsync = new Notification();
                            outofsync.leader = responseBuffer.getLong();
                            outofsync.zxid = responseBuffer.getLong();
                            outofsync.epoch = responseBuffer.getLong();
                            outofsync.state = ackstate;
                            outofsync.addr = (InetSocketAddress)responsePacket.getSocketAddress();
                            AuthFastLeaderElection.this.recvqueue.offer(outofsync);
                            break;
                        }
                        default: {
                            LOG.warn("Received message of incorrect type " + type);
                        }
                    }
                }
            }
        }
    }

    public static class ToSend {
        int type;
        long leader;
        long zxid;
        long epoch;
        QuorumPeer.ServerState state;
        long tag;
        InetSocketAddress addr;

        ToSend(mType type, long tag, long leader, long zxid, long epoch, QuorumPeer.ServerState state, InetSocketAddress addr) {
            switch (type) {
                case crequest: {
                    this.type = 0;
                    this.tag = tag;
                    this.leader = leader;
                    this.zxid = zxid;
                    this.epoch = epoch;
                    this.state = state;
                    this.addr = addr;
                    break;
                }
                case challenge: {
                    this.type = 1;
                    this.tag = tag;
                    this.leader = leader;
                    this.zxid = zxid;
                    this.epoch = epoch;
                    this.state = state;
                    this.addr = addr;
                    break;
                }
                case notification: {
                    this.type = 2;
                    this.leader = leader;
                    this.zxid = zxid;
                    this.epoch = epoch;
                    this.state = QuorumPeer.ServerState.LOOKING;
                    this.tag = tag;
                    this.addr = addr;
                    break;
                }
                case ack: {
                    this.type = 3;
                    this.tag = tag;
                    this.leader = leader;
                    this.zxid = zxid;
                    this.epoch = epoch;
                    this.state = state;
                    this.addr = addr;
                    break;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum mType {
            crequest,
            challenge,
            notification,
            ack;

        }
    }

    public static class Notification {
        long leader;
        long zxid;
        long epoch;
        QuorumPeer.ServerState state;
        InetSocketAddress addr;
    }
}

