/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.regex;

import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.impl.common.XMLChar;
import org.apache.xmlbeans.impl.regex.RegularExpression;

public class SchemaRegularExpression
extends RegularExpression {
    static final Map knownPatterns = SchemaRegularExpression.buildKnownPatternMap();

    private SchemaRegularExpression(String pattern) {
        super(pattern, "X");
    }

    public static RegularExpression forPattern(String s2) {
        SchemaRegularExpression tre = (SchemaRegularExpression)knownPatterns.get(s2);
        if (tre != null) {
            return tre;
        }
        return new RegularExpression(s2, "X");
    }

    private static Map buildKnownPatternMap() {
        HashMap<String, SchemaRegularExpression> result2 = new HashMap<String, SchemaRegularExpression>();
        result2.put("\\c+", new SchemaRegularExpression("\\c+"){

            public boolean matches(String s2) {
                return XMLChar.isValidNmtoken(s2);
            }
        });
        result2.put("\\i\\c*", new SchemaRegularExpression("\\i\\c*"){

            public boolean matches(String s2) {
                return XMLChar.isValidName(s2);
            }
        });
        result2.put("[\\i-[:]][\\c-[:]]*", new SchemaRegularExpression("[\\i-[:]][\\c-[:]]*"){

            public boolean matches(String s2) {
                return XMLChar.isValidNCName(s2);
            }
        });
        return result2;
    }
}

