/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.regex;

import java.text.CharacterIterator;

public class BMPattern {
    char[] pattern;
    int[] shiftTable;
    boolean ignoreCase;

    public BMPattern(String pat, boolean ignoreCase) {
        this(pat, 256, ignoreCase);
    }

    public BMPattern(String pat, int tableSize, boolean ignoreCase) {
        int i;
        this.pattern = pat.toCharArray();
        this.shiftTable = new int[tableSize];
        this.ignoreCase = ignoreCase;
        int length = this.pattern.length;
        for (i = 0; i < this.shiftTable.length; ++i) {
            this.shiftTable[i] = length;
        }
        for (i = 0; i < length; ++i) {
            int diff2 = length - i - 1;
            char ch = this.pattern[i];
            int index2 = ch % this.shiftTable.length;
            if (diff2 < this.shiftTable[index2]) {
                this.shiftTable[index2] = diff2;
            }
            if (!this.ignoreCase) continue;
            index2 = (ch = Character.toUpperCase(ch)) % this.shiftTable.length;
            if (diff2 < this.shiftTable[index2]) {
                this.shiftTable[index2] = diff2;
            }
            if (diff2 >= this.shiftTable[index2 = (ch = Character.toLowerCase(ch)) % this.shiftTable.length]) continue;
            this.shiftTable[index2] = diff2;
        }
    }

    public int matches(CharacterIterator iterator2, int start, int limit) {
        if (this.ignoreCase) {
            return this.matchesIgnoreCase(iterator2, start, limit);
        }
        int plength = this.pattern.length;
        if (plength == 0) {
            return start;
        }
        int index2 = start + plength;
        while (index2 <= limit) {
            char ch;
            int pindex = plength;
            int nindex = index2 + 1;
            while ((ch = iterator2.setIndex(--index2)) == this.pattern[--pindex]) {
                if (pindex == 0) {
                    return index2;
                }
                if (pindex > 0) continue;
            }
            if ((index2 += this.shiftTable[ch % this.shiftTable.length] + 1) >= nindex) continue;
            index2 = nindex;
        }
        return -1;
    }

    public int matches(String str, int start, int limit) {
        if (this.ignoreCase) {
            return this.matchesIgnoreCase(str, start, limit);
        }
        int plength = this.pattern.length;
        if (plength == 0) {
            return start;
        }
        int index2 = start + plength;
        while (index2 <= limit) {
            char ch;
            int pindex = plength;
            int nindex = index2 + 1;
            while ((ch = str.charAt(--index2)) == this.pattern[--pindex]) {
                if (pindex == 0) {
                    return index2;
                }
                if (pindex > 0) continue;
            }
            if ((index2 += this.shiftTable[ch % this.shiftTable.length] + 1) >= nindex) continue;
            index2 = nindex;
        }
        return -1;
    }

    public int matches(char[] chars, int start, int limit) {
        if (this.ignoreCase) {
            return this.matchesIgnoreCase(chars, start, limit);
        }
        int plength = this.pattern.length;
        if (plength == 0) {
            return start;
        }
        int index2 = start + plength;
        while (index2 <= limit) {
            char ch;
            int pindex = plength;
            int nindex = index2 + 1;
            while ((ch = chars[--index2]) == this.pattern[--pindex]) {
                if (pindex == 0) {
                    return index2;
                }
                if (pindex > 0) continue;
            }
            if ((index2 += this.shiftTable[ch % this.shiftTable.length] + 1) >= nindex) continue;
            index2 = nindex;
        }
        return -1;
    }

    int matchesIgnoreCase(CharacterIterator iterator2, int start, int limit) {
        int plength = this.pattern.length;
        if (plength == 0) {
            return start;
        }
        int index2 = start + plength;
        while (index2 <= limit) {
            char ch2;
            char ch;
            char ch1;
            int pindex = plength;
            int nindex = index2 + 1;
            while ((ch1 = (ch = iterator2.setIndex(--index2))) == (ch2 = this.pattern[--pindex]) || (ch1 = Character.toUpperCase(ch1)) == (ch2 = Character.toUpperCase(ch2)) || Character.toLowerCase(ch1) == Character.toLowerCase(ch2)) {
                if (pindex == 0) {
                    return index2;
                }
                if (pindex > 0) continue;
            }
            if ((index2 += this.shiftTable[ch % this.shiftTable.length] + 1) >= nindex) continue;
            index2 = nindex;
        }
        return -1;
    }

    int matchesIgnoreCase(String text, int start, int limit) {
        int plength = this.pattern.length;
        if (plength == 0) {
            return start;
        }
        int index2 = start + plength;
        while (index2 <= limit) {
            char ch2;
            char ch;
            char ch1;
            int pindex = plength;
            int nindex = index2 + 1;
            while ((ch1 = (ch = text.charAt(--index2))) == (ch2 = this.pattern[--pindex]) || (ch1 = Character.toUpperCase(ch1)) == (ch2 = Character.toUpperCase(ch2)) || Character.toLowerCase(ch1) == Character.toLowerCase(ch2)) {
                if (pindex == 0) {
                    return index2;
                }
                if (pindex > 0) continue;
            }
            if ((index2 += this.shiftTable[ch % this.shiftTable.length] + 1) >= nindex) continue;
            index2 = nindex;
        }
        return -1;
    }

    int matchesIgnoreCase(char[] chars, int start, int limit) {
        int plength = this.pattern.length;
        if (plength == 0) {
            return start;
        }
        int index2 = start + plength;
        while (index2 <= limit) {
            char ch2;
            char ch;
            char ch1;
            int pindex = plength;
            int nindex = index2 + 1;
            while ((ch1 = (ch = chars[--index2])) == (ch2 = this.pattern[--pindex]) || (ch1 = Character.toUpperCase(ch1)) == (ch2 = Character.toUpperCase(ch2)) || Character.toLowerCase(ch1) == Character.toLowerCase(ch2)) {
                if (pindex == 0) {
                    return index2;
                }
                if (pindex > 0) continue;
            }
            if ((index2 += this.shiftTable[ch % this.shiftTable.length] + 1) >= nindex) continue;
            index2 = nindex;
        }
        return -1;
    }
}

