/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.piccolo.xml;

import org.apache.xmlbeans.impl.piccolo.util.IntStack;
import org.apache.xmlbeans.impl.piccolo.util.StringStack;

public class FastNamespaceSupport {
    public static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
    private String[] prefixes = new String[20];
    private String[] uris = new String[20];
    private int prefixPos;
    private String defaultURI;
    private StringStack defaultURIs = new StringStack(20);
    private int prefixCount;
    private IntStack contextPrefixCounts = new IntStack(20);
    private int defaultURIContexts;
    private IntStack defaultURIContextCounts = new IntStack(20);

    public FastNamespaceSupport() {
        this.reset();
    }

    public void reset() {
        this.defaultURIs.clear();
        this.contextPrefixCounts.clear();
        this.defaultURIContextCounts.clear();
        this.prefixPos = -1;
        this.defaultURI = "";
        this.prefixCount = 0;
        this.defaultURIContexts = 0;
    }

    public void pushContext() {
        ++this.defaultURIContexts;
        this.contextPrefixCounts.push(this.prefixCount);
        this.prefixCount = 0;
    }

    public void popContext() {
        if (this.defaultURIContexts <= 0) {
            this.defaultURIContexts = this.defaultURIContextCounts.pop();
            this.defaultURI = this.defaultURIs.pop();
        } else {
            --this.defaultURIContexts;
        }
        this.prefixPos -= this.prefixCount;
        this.prefixCount = this.contextPrefixCounts.pop();
    }

    public void declarePrefix(String prefix, String uri) {
        if (prefix.length() == 0) {
            --this.defaultURIContexts;
            this.defaultURIContextCounts.push(this.defaultURIContexts);
            this.defaultURIs.push(this.defaultURI);
            this.defaultURIContexts = 0;
            this.defaultURI = uri;
        } else {
            for (int i = 0; i < this.prefixCount; ++i) {
                if (prefix != this.prefixes[this.prefixPos - i]) continue;
                this.uris[this.prefixPos - i] = uri;
                return;
            }
            ++this.prefixPos;
            ++this.prefixCount;
            if (this.prefixPos >= this.prefixes.length) {
                int oldLength = this.prefixes.length;
                int newLength = oldLength * 2;
                String[] newPrefixes = new String[newLength];
                String[] newURIs = new String[newLength];
                System.arraycopy(this.prefixes, 0, newPrefixes, 0, oldLength);
                System.arraycopy(this.uris, 0, newURIs, 0, oldLength);
                this.prefixes = newPrefixes;
                this.uris = newURIs;
            }
            this.prefixes[this.prefixPos] = prefix;
            this.uris[this.prefixPos] = uri;
        }
    }

    public String[] processName(String qName, String[] parts, boolean isAttribute) {
        int colon2 = qName.indexOf(58);
        parts[2] = qName;
        if (colon2 < 0) {
            parts[1] = qName;
            parts[0] = isAttribute ? "" : this.defaultURI;
            return parts;
        }
        String prefix = qName.substring(0, colon2);
        parts[1] = qName.substring(colon2 + 1);
        parts[0] = this.getURI(prefix);
        if (parts[0] == "") {
            return null;
        }
        return parts;
    }

    public String getDefaultURI() {
        return this.defaultURI;
    }

    public String getURI(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return this.defaultURI;
        }
        if (prefix == "xml") {
            return XMLNS;
        }
        for (int i = this.prefixPos; i >= 0; --i) {
            if (prefix != this.prefixes[i]) continue;
            return this.uris[i];
        }
        return "";
    }

    public int getContextSize() {
        return this.prefixCount + (this.defaultURIContexts == 0 && this.defaultURI != "" ? 1 : 0);
    }

    public String getContextPrefix(int index2) {
        if (index2 == this.prefixCount && this.defaultURIContexts == 0 && this.defaultURI != "") {
            return "";
        }
        return this.prefixes[this.prefixPos - index2];
    }

    public String getContextURI(int index2) {
        if (index2 == this.prefixCount && this.defaultURIContexts == 0 && this.defaultURI != "") {
            return this.defaultURI;
        }
        return this.uris[this.prefixPos - index2];
    }
}

