/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.piccolo.util;

public final class IntStack {
    private int[] stack;
    private int pos;

    public IntStack(int initialSize) {
        this.stack = new int[initialSize];
        this.pos = -1;
    }

    public int pop() {
        if (this.pos >= 0) {
            return this.stack[this.pos--];
        }
        throw new ArrayIndexOutOfBoundsException("stack underflow");
    }

    public void push(int s2) {
        if (this.pos + 1 < this.stack.length) {
            this.stack[++this.pos] = s2;
        } else {
            this.setSize(this.stack.length * 2);
            this.stack[++this.pos] = s2;
        }
    }

    public void setSize(int newSize) {
        if (newSize != this.stack.length) {
            int[] newStack = new int[newSize];
            System.arraycopy(this.stack, 0, newStack, 0, Math.min(this.stack.length, newSize));
            this.stack = newStack;
        }
    }

    public void clear() {
        this.pos = -1;
    }

    public int size() {
        return this.pos + 1;
    }
}

