/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.annotation;

import com.sun.javadoc.Tag;
import java.io.StringWriter;
import java.util.StringTokenizer;
import org.apache.xmlbeans.impl.jam.annotation.JavadocTagParser;
import org.apache.xmlbeans.impl.jam.mutable.MAnnotatedElement;
import org.apache.xmlbeans.impl.jam.mutable.MAnnotation;

public class LineDelimitedTagParser
extends JavadocTagParser {
    private static final String VALUE_QUOTE = "\"";
    private static final String LINE_DELIMS = "\n\f\r";

    public void parse(MAnnotatedElement target, Tag tag) {
        if (target == null) {
            throw new IllegalArgumentException("null tagText");
        }
        if (tag == null) {
            throw new IllegalArgumentException("null tagName");
        }
        MAnnotation[] anns = this.createAnnotations(target, tag);
        String tagText = tag.text();
        StringTokenizer st = new StringTokenizer(tagText, LINE_DELIMS);
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int eq2 = pair.indexOf(61);
            if (eq2 <= 0) continue;
            String name = pair.substring(0, eq2).trim();
            if (eq2 >= pair.length() - 1) continue;
            String value2 = pair.substring(eq2 + 1).trim();
            if (value2.startsWith(VALUE_QUOTE)) {
                value2 = this.parseQuotedValue(value2.substring(1), st);
            }
            this.setValue(anns, name, value2);
        }
    }

    private String parseQuotedValue(String line, StringTokenizer st) {
        int endQuote;
        StringWriter out = new StringWriter();
        while ((endQuote = line.indexOf(VALUE_QUOTE)) == -1) {
            out.write(line);
            if (!st.hasMoreTokens()) {
                return out.toString();
            }
            out.write(10);
            line = st.nextToken().trim();
        }
        out.write(line.substring(0, endQuote).trim());
        return out.toString();
    }
}

